/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.executor.AbstractOperationAwareBeanOperationExecutor;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.MultiMap;
import java.util.Collection;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanOperationFlattingExecutor
extends AbstractOperationAwareBeanOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractBeanOperationFlattingExecutor.class);

    protected AbstractBeanOperationFlattingExecutor(ContainerManager containerManager) {
        super(containerManager);
    }

    @Override
    public void doExecute(@NonNull Collection<?> targets, @NonNull BeanOperations operations, BeanOperationExecutor.Options options) {
        MultiMap<BeanOperations, Object> targetWithOperations = MultiMap.linkedListMultimap();
        targetWithOperations.putAll(operations, targets);
        targetWithOperations = this.executeDisassembleOperations(operations, options, targetWithOperations);
        this.executeAssembleOperations(options, targetWithOperations);
        this.afterOperationsCompletion(targetWithOperations);
    }

    @Override
    protected MultiMap<BeanOperations, Object> doExecuteDisassembleOperations(Predicate<? super KeyTriggerOperation> filter, MultiMap<BeanOperations, Object> targetWithOps) {
        MultiMap<BeanOperations, Object> results = MultiMap.linkedListMultimap();
        results.putAll(targetWithOps);
        targetWithOps.asMap().forEach((ops, targets) -> this.disassembleIfNecessary((Collection)targets, (BeanOperations)ops, filter, results));
        return results;
    }

    private <T> void disassembleIfNecessary(Collection<T> targets, BeanOperations operations, Predicate<? super KeyTriggerOperation> filter, MultiMap<BeanOperations, Object> collectedTargets) {
        Collection<DisassembleOperation> internalOperations = operations.getDisassembleOperations();
        if (CollectionUtils.isEmpty(internalOperations)) {
            return;
        }
        internalOperations.stream().filter(filter).forEach(internal -> this.doDisassembleAndCollect(targets, (DisassembleOperation)internal, filter, collectedTargets));
    }

    private <T> void doDisassembleAndCollect(Collection<T> targets, DisassembleOperation disassembleOperation, Predicate<? super KeyTriggerOperation> filter, MultiMap<BeanOperations, Object> collector) {
        DisassembleOperationHandler handler = disassembleOperation.getDisassembleOperationHandler();
        Collection<Object> internalTargets = handler.process(disassembleOperation, targets = this.filterTargetsForSupportedOperation(targets, disassembleOperation));
        if (CollectionUtils.isEmpty(internalTargets)) {
            return;
        }
        BeanOperations internalOperations = disassembleOperation.getInternalBeanOperations(internalTargets);
        collector.putAll(internalOperations, internalTargets);
        this.disassembleIfNecessary(internalTargets, internalOperations, filter, collector);
    }
}

