/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.EmptyContainer;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ObjectUtils;
import cn.crane4j.core.util.TimerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAssembleOperationHandler
implements AssembleOperationHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractAssembleOperationHandler.class);
    protected boolean ignoreNullKey = false;

    @Override
    public void process(Container<?> container, Collection<AssembleExecution> executions) {
        TimerUtil.getExecutionTime(log.isDebugEnabled(), time -> log.debug("operation of container [{}] completed in {} ms", (Object)container.getNamespace(), (Object)time), () -> this.doProcess(container, executions));
    }

    private void doProcess(Container<?> container, Collection<AssembleExecution> executions) {
        Collection<Target> targets = this.collectToEntities(executions);
        if (container instanceof EmptyContainer || Objects.isNull(container)) {
            this.introspectForEntities(targets);
            return;
        }
        Map<Object, Object> sources = this.getSourcesFromContainer(container, targets);
        if (CollectionUtils.isEmpty(sources)) {
            return;
        }
        for (Target target : targets) {
            Object source = this.getTheAssociatedSource(target, sources);
            if (!ObjectUtils.isNotEmpty(source)) continue;
            this.completeMapping(source, target);
        }
    }

    private Collection<Target> collectToEntities(Collection<AssembleExecution> executions) {
        ArrayList<Target> targets = new ArrayList<Target>();
        for (AssembleExecution execution : executions) {
            AssembleOperation operation = execution.getOperation();
            KeyResolver resolver = this.determineKeyResolver(operation);
            execution.getTargets().stream().map(t -> this.createTarget(execution, t, resolver.resolve(t, operation))).filter(Objects::nonNull).filter(t -> !this.ignoreNullKey || Objects.nonNull(t.getKey())).forEach(targets::add);
        }
        return targets;
    }

    protected void introspectForEntities(Collection<Target> targets) {
        for (Target target : targets) {
            this.completeMapping(target.getOrigin(), target);
        }
    }

    protected Map<Object, Object> getSourcesFromContainer(Container<?> container, Collection<Target> targets) {
        Set keys = targets.stream().map(Target::getKey).filter(Objects::nonNull).collect(Collectors.toSet());
        return container.get(keys);
    }

    protected Object getTheAssociatedSource(Target target, Map<Object, Object> sources) {
        return sources.get(target.getKey());
    }

    protected abstract void completeMapping(Object var1, Target var2);

    protected @Nullable Target createTarget(AssembleExecution execution, Object origin, Object keyValue) {
        return new Target(execution, origin, keyValue);
    }

    public void setIgnoreNullKey(boolean ignoreNullKey) {
        this.ignoreNullKey = ignoreNullKey;
    }

    protected static class Target {
        private final AssembleExecution execution;
        protected Object origin;
        private Object key;

        public AssembleExecution getExecution() {
            return this.execution;
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getKey() {
            return this.key;
        }

        public Target(AssembleExecution execution, Object origin, Object key) {
            this.execution = execution;
            this.origin = origin;
            this.key = key;
        }
    }
}

