/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler;

import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.handler.AbstractAssembleOperationHandler;
import cn.crane4j.core.executor.handler.key.IntrospectionKeyResolver;
import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.executor.handler.key.ReflectiveBeanKeyResolver;
import cn.crane4j.core.executor.handler.key.ReflectivePropertyKeyResolver;
import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.SimplePropertyMapping;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OneToOneAssembleOperationHandler
extends AbstractAssembleOperationHandler {
    protected final PropertyOperator propertyOperator;
    protected final ConverterManager converterManager;
    private final KeyResolver keyResolver;
    private final KeyResolver converterKeyResolver;

    public OneToOneAssembleOperationHandler(PropertyOperator propertyOperator, ConverterManager converterManager) {
        this.propertyOperator = propertyOperator;
        this.converterManager = converterManager;
        this.keyResolver = ReflectivePropertyKeyResolver.create(propertyOperator);
        this.converterKeyResolver = ReflectivePropertyKeyResolver.create(propertyOperator, converterManager);
    }

    @Override
    public KeyResolver determineKeyResolver(AssembleOperation operation) {
        boolean specifiedKeyType;
        KeyResolver specifiedkeyResolver = operation.getKeyResolver();
        if (Objects.nonNull(specifiedkeyResolver)) {
            return specifiedkeyResolver;
        }
        Class<?> keyType = operation.getKeyType();
        boolean bl = specifiedKeyType = Objects.nonNull(keyType) && !ClassUtils.isObjectOrVoid(keyType);
        if (StringUtils.isNotEmpty(operation.getKey())) {
            return specifiedKeyType ? this.converterKeyResolver : this.keyResolver;
        }
        if (Objects.isNull(keyType)) {
            return IntrospectionKeyResolver.INSTANCE;
        }
        if (this.isInstantiableCustomClass(keyType)) {
            String keyDescription = operation.getKeyDescription();
            Set<PropertyMapping> propertyMappings = StringUtils.isEmpty(keyDescription) ? this.resolvePropertyMappings(keyType) : this.resolvePropertyMappings(keyDescription);
            return new ReflectiveBeanKeyResolver(this.propertyOperator, propertyMappings.toArray(new PropertyMapping[0]));
        }
        return null;
    }

    private boolean isInstantiableCustomClass(@Nullable Class<?> keyType) {
        return Objects.nonNull(keyType) && (!ClassUtils.isJdkClass(keyType) || Map.class.isAssignableFrom(keyType)) && ClassUtils.isInstantiable(keyType, null);
    }

    private Set<PropertyMapping> resolvePropertyMappings(Class<?> targetType) {
        return Arrays.stream(ReflectUtils.getFields(targetType)).map(field -> new SimplePropertyMapping(field.getName(), field.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<PropertyMapping> resolvePropertyMappings(String keyDescription) {
        Set<PropertyMapping> mappings = SimplePropertyMapping.from(keyDescription);
        mappings.forEach(m -> Asserts.isTrue(m.hasSource() && StringUtils.isNotEmpty(m.getReference()), "The property mappings is illegal: {} -> {}", m.getReference(), m.getSource()));
        return mappings;
    }

    @Override
    protected void completeMapping(Object source, AbstractAssembleOperationHandler.Target target) {
        AssembleExecution execution = target.getExecution();
        AssembleOperation operation = execution.getOperation();
        PropertyMappingStrategy propertyMappingStrategy = operation.getPropertyMappingStrategy();
        Set<PropertyMapping> mappings = operation.getPropertyMappings();
        this.doCompleteMapping(operation, source, target.getOrigin(), mappings, propertyMappingStrategy);
    }

    private void doCompleteMapping(AssembleOperation operation, Object source, Object target, Set<PropertyMapping> mappings, PropertyMappingStrategy propertyMappingStrategy) {
        PropDesc sourceDesc = this.propertyOperator.getPropertyDescriptor(source.getClass());
        PropDesc targetDesc = this.propertyOperator.getPropertyDescriptor(target.getClass());
        for (PropertyMapping mapping : mappings) {
            Object sourceValue = mapping.hasSource() ? sourceDesc.readProperty(source, mapping.getSource()) : source;
            propertyMappingStrategy.doMapping(operation, target, source, sourceValue, mapping, sv -> targetDesc.writeProperty(target, mapping.getReference(), sourceValue));
        }
    }
}

