/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.annotation.AssembleMethod;
import cn.crane4j.core.cache.CacheableContainer;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDelegate;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.handler.AbstractInternalProviderAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AbstractStandardAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AbstractStandardOperationAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.container.AbstractContainerMethodSupport;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleMethodAnnotationHandler
extends AbstractInternalProviderAssembleAnnotationHandler<AssembleMethod> {
    private static final Logger log = LoggerFactory.getLogger(AssembleMethodAnnotationHandler.class);
    protected final ContainerMethodResolver containerMethodResolver;

    public AssembleMethodAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, Collection<MethodContainerFactory> methodContainerFactories, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        super(AssembleMethod.class, annotationFinder, Crane4jGlobalSorter.comparator(), globalConfiguration, propertyMappingStrategyManager);
        this.containerMethodResolver = this.createContainerMethodResolver(methodContainerFactories);
    }

    protected ContainerMethodResolver createContainerMethodResolver(Collection<MethodContainerFactory> methodContainerFactories) {
        return new CacheableContainerMethodResolver(methodContainerFactories);
    }

    @Override
    protected @NonNull Container<Object> createContainer(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<AssembleMethod> standardAnnotation, String namespace) {
        AssembleMethod annotation = (AssembleMethod)standardAnnotation.getAnnotation();
        Container<Object> container = this.containerMethodResolver.resolve(annotation);
        Asserts.isNotNull(container, "cannot resolve container for annotation {}", annotation);
        return new AssembleMethodContainer<Object>(namespace, container);
    }

    public void registerMethodContainerFactory(@NonNull MethodContainerFactory methodContainerFactory) {
        this.containerMethodResolver.registerMethodContainerFactory(methodContainerFactory);
    }

    @Override
    protected String determineNamespace(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<AssembleMethod> standardAnnotation) {
        AssembleMethod annotation = (AssembleMethod)standardAnnotation.getAnnotation();
        return StringUtils.md5DigestAsHex(StringUtils.join(String::valueOf, "#", annotation.method(), annotation.target(), annotation.targetType()));
    }

    @Override
    protected AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<AssembleMethod> getStandardAnnotation(BeanOperations beanOperations, AnnotatedElement element, AssembleMethod annotation) {
        return ((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardOperationAnnotationHandler.StandardAnnotationAdapter.StandardAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.builder().annotatedElement(element)).annotation(annotation)).id(annotation.id())).key(annotation.key())).keyResolver(annotation.keyResolver())).keyDesc(annotation.keyDesc())).sort(annotation.sort())).groups(annotation.groups())).keyType(annotation.keyType())).handler(annotation.handler())).handlerType(annotation.handlerType())).mappingTemplates(annotation.propTemplates())).props(annotation.props())).prop(annotation.prop())).propertyMappingStrategy(annotation.propertyMappingStrategy())).build();
    }

    protected @NonNull Class<?> resolveTargetType(AssembleMethod annotation) {
        return ClassUtils.forName(annotation.target(), annotation.targetType());
    }

    protected @Nullable Object getTargetInstance(Class<?> targetType, AssembleMethod annotation) {
        try {
            return ClassUtils.newInstance(targetType, new Object[0]);
        }
        catch (Exception ex) {
            log.warn("cannot create target instance of assemble method for class [{}]", targetType);
            throw ex;
        }
    }

    private static class AssembleMethodContainer<T>
    implements ContainerDelegate<T> {
        private final String namespace;
        private final Container<T> container;

        @Override
        public Map<T, ?> get(Collection<T> keys) {
            return this.container.get(keys);
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public Container<T> getContainer() {
            return this.container;
        }

        public AssembleMethodContainer(String namespace, Container<T> container) {
            this.namespace = namespace;
            this.container = container;
        }
    }

    protected class ContainerMethodResolver
    extends AbstractContainerMethodSupport {
        protected ContainerMethodResolver(Collection<MethodContainerFactory> methodContainerFactories) {
            super(methodContainerFactories);
        }

        public @Nullable Container<Object> resolve(AssembleMethod annotation) {
            Class<?> targetType = AssembleMethodAnnotationHandler.this.resolveTargetType(annotation);
            Asserts.isNotNull(targetType, "cannot resolve target type from annotation {}", annotation);
            Method resolvedMethod = this.getContainerMethod(annotation, targetType);
            Asserts.isNotNull(resolvedMethod, "cannot resolve method of class [{}] from annotation [{}]", targetType, annotation);
            Object target = Modifier.isStatic(resolvedMethod.getModifiers()) ? null : AssembleMethodAnnotationHandler.this.getTargetInstance(targetType, annotation);
            return CollectionUtils.get(this.createMethodContainer(target, resolvedMethod, Collections.singleton(annotation.method())), 0);
        }

        private @Nullable Method getContainerMethod(AssembleMethod annotation, Class<?> targetType) {
            Method[] methods = ReflectUtils.getMethods(targetType);
            return this.findMatchedMethodForAnnotation(Arrays.asList(methods), annotation.method());
        }
    }

    protected class CacheableContainerMethodResolver
    extends ContainerMethodResolver {
        protected CacheableContainerMethodResolver(Collection<MethodContainerFactory> methodContainerFactories) {
            super(methodContainerFactories);
        }

        @Override
        public @Nullable Container<Object> resolve(AssembleMethod annotation) {
            Container<Object> container = super.resolve(annotation);
            return Optional.ofNullable(container).filter(c -> !this.isCached((Container<?>)c)).filter(c -> annotation.enableCache()).map(c -> ConfigurationUtil.wrapToCacheableContainer(annotation.cache(), AssembleMethodAnnotationHandler.this.globalConfiguration, c)).orElse(container);
        }

        private boolean isCached(Container<?> container) {
            while (container instanceof ContainerDelegate) {
                if (container instanceof CacheableContainer) {
                    return true;
                }
                container = ((ContainerDelegate)container).getContainer();
            }
            return false;
        }
    }
}

