/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support;

import cn.crane4j.core.util.ArrayUtils;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Grouped {
    public static Predicate<Grouped> allMatch(String ... groups) {
        return ArrayUtils.isEmpty(groups) ? Grouped.alwaysMatch() : t -> Stream.of(groups).allMatch(t::isBelong);
    }

    public static Predicate<Grouped> noneMatch(String ... groups) {
        return ArrayUtils.isEmpty(groups) ? Grouped.alwaysMatch() : t -> Stream.of(groups).noneMatch(t::isBelong);
    }

    public static Predicate<Grouped> anyMatch(String ... groups) {
        return ArrayUtils.isEmpty(groups) ? Grouped.alwaysNoneMatch() : t -> Stream.of(groups).anyMatch(t::isBelong);
    }

    public static Predicate<Grouped> alwaysMatch() {
        return grouped -> true;
    }

    public static Predicate<Grouped> alwaysNoneMatch() {
        return grouped -> false;
    }

    default public Set<String> getGroups() {
        return Collections.emptySet();
    }

    default public boolean isBelong(String group) {
        return this.getGroups().contains(group);
    }
}

