/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.aop;

import cn.crane4j.annotation.ArgAutoOperate;
import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.aop.MethodArgumentAutoOperateSupport;
import cn.crane4j.core.support.aop.MethodResultAutoOperateSupport;
import cn.crane4j.core.support.proxy.ProxyFactory;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoOperateProxy {
    private static final Logger log = LoggerFactory.getLogger(AutoOperateProxy.class);
    private final ResultHandler resultHandler = new ResultHandler();
    private final ArgumentsHandler argumentsHandler = new ArgumentsHandler();
    private final ResultAndArgumentsHandler resultAndArgumentsHandler = new ResultAndArgumentsHandler();
    private final MethodArgumentAutoOperateSupport methodArgumentAutoOperateSupport;
    private final MethodResultAutoOperateSupport methodResultAutoOperateSupport;
    private final AnnotationFinder annotationFinder;
    private final ProxyFactory proxyFactory;

    public <T> T wrapIfNecessary(T target) {
        Class<?> proxyType = target.getClass();
        Asserts.isFalse(Proxy.isProxyClass(proxyType), "target is already proxied: {}", proxyType);
        Map<Method, MethodHandler> methodHandles = this.resolveMethodHandler(proxyType);
        if (methodHandles.isEmpty()) {
            log.info("no method need to be proxied: {}", proxyType);
            return target;
        }
        return this.proxyFactory.createProxy(new AutoOperateMethodHandler(methodHandles, target), proxyType);
    }

    private @NonNull Map<Method, MethodHandler> resolveMethodHandler(Class<?> targetType) {
        HashMap<Method, MethodHandler> methodHandles = new HashMap<Method, MethodHandler>(16);
        ReflectUtils.traverseTypeHierarchy(targetType, type -> {
            if (!Objects.equals(Object.class, type)) {
                this.processHandleableMethods((Class<?>)type, (Map<Method, MethodHandler>)methodHandles);
            }
        });
        return methodHandles;
    }

    private void processHandleableMethods(Class<?> t, Map<Method, MethodHandler> methodHandles) {
        Stream.of(ReflectUtils.getDeclaredMethods(t)).filter(this::isHandleableMethod).forEach(m -> {
            MethodHandler handler = this.determineHandler((Method)m);
            if (Objects.nonNull(handler)) {
                methodHandles.putIfAbsent((Method)m, handler);
            }
        });
    }

    private boolean isHandleableMethod(Method method) {
        if (method.isSynthetic()) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    private @Nullable MethodHandler determineHandler(Method method) {
        AutoOperate annotation = this.annotationFinder.getAnnotation(method, AutoOperate.class);
        if (Objects.isNull(annotation)) {
            return this.needHandleArgs(method) ? this.argumentsHandler : null;
        }
        return this.needHandleArgs(method) ? this.resultAndArgumentsHandler : this.resultHandler;
    }

    private boolean needHandleArgs(Method method) {
        return this.annotationFinder.hasAnnotation(method, ArgAutoOperate.class) || Stream.of(method.getParameters()).anyMatch(m -> this.annotationFinder.hasAnnotation((AnnotatedElement)m, (Class<? extends Annotation>)AutoOperate.class));
    }

    public AutoOperateProxy(MethodArgumentAutoOperateSupport methodArgumentAutoOperateSupport, MethodResultAutoOperateSupport methodResultAutoOperateSupport, AnnotationFinder annotationFinder, ProxyFactory proxyFactory) {
        this.methodArgumentAutoOperateSupport = methodArgumentAutoOperateSupport;
        this.methodResultAutoOperateSupport = methodResultAutoOperateSupport;
        this.annotationFinder = annotationFinder;
        this.proxyFactory = proxyFactory;
    }

    private class ResultAndArgumentsHandler
    implements MethodHandler {
        @Override
        public Object invoke(Object target, Method method, Object[] arguments) {
            AutoOperateProxy.this.methodArgumentAutoOperateSupport.beforeMethodInvoke(method, arguments);
            Object result = ReflectUtils.invoke(target, method, arguments);
            AutoOperateProxy.this.methodResultAutoOperateSupport.afterMethodInvoke(method, result, arguments);
            return result;
        }
    }

    private class ArgumentsHandler
    implements MethodHandler {
        @Override
        public Object invoke(Object target, Method method, Object[] arguments) {
            AutoOperateProxy.this.methodArgumentAutoOperateSupport.beforeMethodInvoke(method, arguments);
            return ReflectUtils.invoke(target, method, arguments);
        }
    }

    private class ResultHandler
    implements MethodHandler {
        @Override
        public Object invoke(Object target, Method method, Object[] arguments) {
            Object result = ReflectUtils.invoke(target, method, arguments);
            AutoOperateProxy.this.methodResultAutoOperateSupport.afterMethodInvoke(method, result, arguments);
            return result;
        }
    }

    private static interface MethodHandler {
        public Object invoke(Object var1, Method var2, Object[] var3);
    }

    private static class AutoOperateMethodHandler
    implements InvocationHandler {
        private final Map<Method, MethodHandler> methodHandles;
        private final Object target;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            MethodHandler handler = this.methodHandles.get(method);
            return Objects.isNull(handler) ? ReflectUtils.invokeRaw(this.target, method, args) : handler.invoke(this.target, method, args);
        }

        public AutoOperateMethodHandler(Map<Method, MethodHandler> methodHandles, Object target) {
            this.methodHandles = methodHandles;
            this.target = target;
        }
    }
}

