/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.auto;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.util.Asserts;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComposableAutoOperateAnnotatedElementResolver
implements AutoOperateAnnotatedElementResolver {
    private final List<AutoOperateAnnotatedElementResolver> resolvers;

    public void addResolver(AutoOperateAnnotatedElementResolver resolver) {
        if (resolver == this) {
            return;
        }
        Asserts.isNotNull(resolver, "resolver must not be null", new Object[0]);
        this.resolvers.remove(resolver);
        this.resolvers.add(resolver);
    }

    public void removeResolver(AutoOperateAnnotatedElementResolver resolver) {
        this.resolvers.remove(resolver);
    }

    @Override
    public boolean support(AnnotatedElement element, @Nullable AutoOperate annotation) {
        return this.resolvers.stream().anyMatch(resolver -> resolver.support(element, annotation));
    }

    @Override
    public @Nullable AutoOperateAnnotatedElement resolve(AnnotatedElement element, @Nullable AutoOperate annotation) {
        return this.resolvers.stream().filter(resolver -> resolver.support(element, annotation)).map(resolver -> resolver.resolve(element, annotation)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public List<AutoOperateAnnotatedElementResolver> getResolvers() {
        return this.resolvers;
    }

    public ComposableAutoOperateAnnotatedElementResolver(List<AutoOperateAnnotatedElementResolver> resolvers) {
        this.resolvers = resolvers;
    }
}

