/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.auto;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.auto.AbstractAutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.auto.DefaultAutoOperateAnnotatedElement;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MethodBasedAutoOperateAnnotatedElementResolver
extends AbstractAutoOperateAnnotatedElementResolver {
    private final TypeResolver typeResolver;

    public MethodBasedAutoOperateAnnotatedElementResolver(Crane4jGlobalConfiguration configuration, TypeResolver typeResolver) {
        super(configuration);
        this.typeResolver = typeResolver;
    }

    @Override
    public boolean support(AnnotatedElement element, @Nullable AutoOperate annotation) {
        return element instanceof Method || element instanceof Parameter;
    }

    @Override
    protected @Nullable AutoOperateAnnotatedElement createAutoOperateAnnotatedElement(AnnotatedElement element, AutoOperate annotation, BeanOperationParser parser, BeanOperationExecutor executor, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter) {
        if (!this.support(element, annotation)) {
            return null;
        }
        if (annotation.resolveOperationsFromCurrentElement()) {
            BeanOperations beanOperations = parser.parse(element);
            return beanOperations.isEmpty() ? null : DefaultAutoOperateAnnotatedElement.forStaticTypeOperation(annotation, element, extractor, filter, beanOperations, executor);
        }
        Class annotationSpecifiedType = annotation.type();
        if (!ClassUtils.isObjectOrVoid(annotationSpecifiedType)) {
            BeanOperations beanOperations = parser.parse(annotation.type());
            return beanOperations.isEmpty() ? null : DefaultAutoOperateAnnotatedElement.forStaticTypeOperation(annotation, element, extractor, filter, beanOperations, executor);
        }
        Function<Object, BeanOperations> dynamicParser = t -> Optional.ofNullable(t).map(this.typeResolver::resolve).map(parser::parse).orElse(BeanOperations.empty());
        return DefaultAutoOperateAnnotatedElement.forDynamicTypeOperation(annotation, element, extractor, filter, executor, dynamicParser);
    }

    @Override
    protected MethodInvoker resolveExtractor(AnnotatedElement element, AutoOperate annotation) {
        Class<?> type = MethodBasedAutoOperateAnnotatedElementResolver.resolveTypeForExtractor(element);
        String on = annotation.on();
        MethodInvoker extractor = (t, args) -> t;
        if (StringUtils.isNotEmpty(on)) {
            PropertyOperator propertyOperator = this.configuration.getPropertyOperator();
            extractor = propertyOperator.findGetter(type, on);
            Asserts.isNotNull(extractor, "cannot find getter for [{}] on [{}]", on, annotation.type());
        }
        return extractor;
    }

    private static Class<?> resolveTypeForExtractor(AnnotatedElement element) {
        if (element instanceof Method) {
            return ((Method)element).getReturnType();
        }
        if (element instanceof Parameter) {
            return ((Parameter)element).getType();
        }
        throw new Crane4jException("Unable to parse the actual type of the annotated element [{}], is it a Parameter or Method?", element);
    }
}

