/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.query;

import cn.crane4j.annotation.DuplicateStrategy;
import cn.crane4j.annotation.MappingType;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface QueryDefinition {
    public @Nullable String getDatasource();

    public MappingType getMappingType();

    public String getRepositoryId();

    public Set<String> getSelectColumns();

    public @Nullable String getConditionColumn();

    public DuplicateStrategy getDuplicateStrategy();

    public static class Impl
    implements QueryDefinition {
        private final String datasource;
        private final MappingType mappingType;
        private final String repositoryId;
        private final Set<String> selectColumns;
        private final String conditionColumn;
        private final DuplicateStrategy duplicateStrategy;

        @Override
        public String getDatasource() {
            return this.datasource;
        }

        @Override
        public MappingType getMappingType() {
            return this.mappingType;
        }

        @Override
        public String getRepositoryId() {
            return this.repositoryId;
        }

        @Override
        public Set<String> getSelectColumns() {
            return this.selectColumns;
        }

        @Override
        public String getConditionColumn() {
            return this.conditionColumn;
        }

        @Override
        public DuplicateStrategy getDuplicateStrategy() {
            return this.duplicateStrategy;
        }

        public Impl(String datasource, MappingType mappingType, String repositoryId, Set<String> selectColumns, String conditionColumn, DuplicateStrategy duplicateStrategy) {
            this.datasource = datasource;
            this.mappingType = mappingType;
            this.repositoryId = repositoryId;
            this.selectColumns = selectColumns;
            this.conditionColumn = conditionColumn;
            this.duplicateStrategy = duplicateStrategy;
        }
    }
}

