/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import com.esotericsoftware.reflectasm.FieldAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AsmReflectivePropertyOperator
extends ReflectivePropertyOperator {
    public AsmReflectivePropertyOperator(@Nullable ConverterManager converterManager) {
        super(converterManager);
    }

    @Override
    public @NonNull PropDesc getPropertyDescriptor(Class<?> targetType) {
        return new AsmReflectivePropDesc(targetType, this.converterManager, this.throwIfNoAnyMatched);
    }

    public AsmReflectivePropertyOperator() {
    }

    public static abstract class AbstractReflectAsmFieldInvoker
    implements MethodInvoker {
        private final FieldAccess fieldAccess;
        private final int fieldIndex;

        protected AbstractReflectAsmFieldInvoker(FieldAccess fieldAccess, int fieldIndex) {
            this.fieldAccess = fieldAccess;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public Object invoke(@Nullable Object target, Object ... args) {
            return this.invoke(this.fieldAccess, this.fieldIndex, target, args);
        }

        protected abstract Object invoke(FieldAccess var1, int var2, @Nullable Object var3, Object ... var4);

        public static class Setter
        extends AbstractReflectAsmFieldInvoker {
            public Setter(FieldAccess fieldAccess, int fieldIndex) {
                super(fieldAccess, fieldIndex);
            }

            @Override
            protected Object invoke(FieldAccess fieldAccess, int fieldIndex, @Nullable Object target, Object ... args) {
                fieldAccess.set(target, fieldIndex, args[0]);
                return null;
            }
        }

        public static class Getter
        extends AbstractReflectAsmFieldInvoker {
            public Getter(FieldAccess fieldAccess, int fieldIndex) {
                super(fieldAccess, fieldIndex);
            }

            @Override
            protected Object invoke(FieldAccess fieldAccess, int fieldIndex, @Nullable Object target, Object ... args) {
                return fieldAccess.get(target, fieldIndex);
            }
        }
    }

    public static class ReflectAsmMethodInvoker
    implements MethodInvoker {
        private final int methodIndex;
        private final MethodAccess methodAccess;

        @Override
        public Object invoke(@Nullable Object target, Object ... args) {
            return this.methodAccess.invoke(target, this.methodIndex, args);
        }

        public ReflectAsmMethodInvoker(int methodIndex, MethodAccess methodAccess) {
            this.methodIndex = methodIndex;
            this.methodAccess = methodAccess;
        }
    }

    protected static class AsmReflectivePropDesc
    extends ReflectivePropertyOperator.ReflectivePropDesc {
        private final Map<Class<?>, MethodAccess> methodAccessCaches = new ConcurrentHashMap();
        private final Map<Class<?>, FieldAccess> fieldAccessCaches = new ConcurrentHashMap();

        public AsmReflectivePropDesc(Class<?> beanType, @Nullable ConverterManager converterManager, boolean throwIfNoAnyMatched) {
            super(beanType, converterManager, throwIfNoAnyMatched);
        }

        @Override
        protected MethodInvoker createSetterInvokerForField(String propertyName, Field field) {
            if (Modifier.isPrivate(field.getModifiers())) {
                return super.createSetterInvokerForField(propertyName, field);
            }
            FieldAccess access = CollectionUtils.computeIfAbsent(this.fieldAccessCaches, this.beanType, FieldAccess::get);
            try {
                int fieldIndex = access.getIndex(field.getName());
                return new AbstractReflectAsmFieldInvoker.Setter(access, fieldIndex);
            }
            catch (IllegalArgumentException e) {
                return super.createSetterInvokerForField(propertyName, field);
            }
        }

        @Override
        protected MethodInvoker createGetterInvokerForField(String propertyName, Field field) {
            if (Modifier.isPrivate(field.getModifiers())) {
                return super.createGetterInvokerForField(propertyName, field);
            }
            FieldAccess access = CollectionUtils.computeIfAbsent(this.fieldAccessCaches, this.beanType, FieldAccess::get);
            try {
                int fieldIndex = access.getIndex(field.getName());
                return new AbstractReflectAsmFieldInvoker.Getter(access, fieldIndex);
            }
            catch (IllegalArgumentException e) {
                return super.createGetterInvokerForField(propertyName, field);
            }
        }

        @Override
        protected MethodInvoker createInvokerForMethod(String propertyName, Method method) {
            MethodAccess access = CollectionUtils.computeIfAbsent(this.methodAccessCaches, this.beanType, MethodAccess::get);
            int methodIndex = access.getIndex(method.getName(), (Class[])method.getParameterTypes());
            return new ReflectAsmMethodInvoker(methodIndex, access);
        }
    }
}

