/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectUtils {
    public static @Nullable Class<?> getElementType(Object target) {
        if (Objects.isNull(target)) {
            return null;
        }
        Object firstNonNull = target;
        if (target instanceof Iterator) {
            firstNonNull = CollectionUtils.getFirstNotNull((Iterator)target);
        } else if (target instanceof Iterable) {
            firstNonNull = CollectionUtils.getFirstNotNull((Iterable)target);
        } else if (target.getClass().isArray()) {
            firstNonNull = ArrayUtils.getFirstNotNull((Object[])target);
        }
        return Objects.isNull(firstNonNull) ? null : firstNonNull.getClass();
    }

    public static <T> T defaultIfNull(T target, T defaultValue) {
        return Objects.isNull(target) ? defaultValue : target;
    }

    public static <T> @Nullable T get(Object target, int index) {
        if (Objects.isNull(target)) {
            return null;
        }
        if (target instanceof List) {
            return CollectionUtils.get((List)target, index);
        }
        if (target instanceof Iterator) {
            Iterator iterator = (Iterator)target;
            return CollectionUtils.get(iterator, index);
        }
        if (target instanceof Iterable) {
            return CollectionUtils.get((Iterable)target, index);
        }
        if (target instanceof Map) {
            return ObjectUtils.get(((Map)target).values(), index);
        }
        if (target.getClass().isArray()) {
            Object[] array = (Object[])target;
            return (T)ArrayUtils.get(array, index);
        }
        return null;
    }

    public static boolean isEmpty(Object target) {
        if (Objects.isNull(target)) {
            return true;
        }
        if (target instanceof Map) {
            return CollectionUtils.isEmpty((Map)target);
        }
        if (target instanceof Iterable) {
            return CollectionUtils.isEmpty((Iterable)target);
        }
        if (target instanceof Iterator) {
            return CollectionUtils.isEmpty((Iterator)target);
        }
        if (target.getClass().isArray()) {
            return ArrayUtils.isEmpty((Object[])target);
        }
        if (target instanceof CharSequence) {
            return StringUtils.isEmpty((CharSequence)target);
        }
        return false;
    }

    public static boolean isNotEmpty(Object target) {
        return !ObjectUtils.isEmpty(target);
    }

    private ObjectUtils() {
    }
}

