/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CheckedFunction;
import cn.crane4j.core.util.CheckedRunnable;
import cn.crane4j.core.util.CheckedSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Try<T> {
    private final CheckedSupplier<T> supplier;
    private List<Consumer<Throwable>> failureSubscribers;
    private List<Consumer<T>> successSubscribers;
    private T result;
    private Throwable cause;
    private boolean performed = false;

    public static Try<Void> of(CheckedRunnable runnable) {
        Asserts.isNotNull(runnable, "runnable must not be null", new Object[0]);
        return new Try<Void>(runnable.toSupplier());
    }

    public static <R> Try<R> of(CheckedSupplier<R> supplier) {
        Asserts.isNotNull(supplier, "supplier must not be null", new Object[0]);
        return new Try<R>(supplier);
    }

    public static <R> Try<R> success(R result) {
        Try<Object> action = new Try<Object>(() -> result);
        action.performed = true;
        action.result = result;
        return action;
    }

    public static <R> Try<R> failure(Throwable ex) {
        Try<Object> action = new Try<Object>(() -> {
            throw ex;
        });
        action.performed = true;
        action.cause = ex;
        return action;
    }

    public final void perform() {
        if (this.isPerformed()) {
            return;
        }
        try {
            this.result = this.supplier.get();
            if (Objects.nonNull(this.successSubscribers) && !this.successSubscribers.isEmpty()) {
                this.successSubscribers.forEach(subscriber -> subscriber.accept(this.result));
            }
        }
        catch (Throwable ex) {
            if (Objects.nonNull(this.successSubscribers) && !this.failureSubscribers.isEmpty()) {
                this.failureSubscribers.forEach(subscriber -> subscriber.accept(ex));
            }
            this.cause = ex;
        }
        finally {
            this.performed = true;
        }
    }

    public boolean isSuccess() {
        this.perform();
        return Objects.isNull(this.cause);
    }

    public boolean isFailure() {
        this.perform();
        return Objects.nonNull(this.cause);
    }

    public @Nullable Throwable getCause() {
        this.perform();
        return this.cause;
    }

    public Try<T> subscribeFailure(Consumer<Throwable> subscriber) {
        Asserts.isFalse(this.performed, "the computation has been performed", new Object[0]);
        Asserts.isNotNull(subscriber, "subscriber must not be null", new Object[0]);
        if (Objects.isNull(this.failureSubscribers)) {
            this.failureSubscribers = new ArrayList<Consumer<Throwable>>();
        }
        this.failureSubscribers.add(subscriber);
        return this;
    }

    public Try<T> subscribeSuccess(Consumer<T> subscriber) {
        Asserts.isFalse(this.performed, "the computation has been performed", new Object[0]);
        Asserts.isNotNull(subscriber, "subscriber must not be null", new Object[0]);
        if (Objects.isNull(this.successSubscribers)) {
            this.successSubscribers = new ArrayList<Consumer<T>>();
        }
        this.successSubscribers.add(subscriber);
        return this;
    }

    public T get() throws Throwable {
        if (this.isSuccess()) {
            return this.result;
        }
        throw this.cause;
    }

    public T getOrNull() {
        return this.isSuccess() ? (T)this.result : null;
    }

    public Optional<T> getOptional() {
        return this.isSuccess() ? Optional.ofNullable(this.result) : Optional.empty();
    }

    public T getOrElse(T defaultValue) {
        return this.isSuccess() ? this.result : defaultValue;
    }

    public T getOrElseGet(Function<Throwable, T> function) {
        return this.isSuccess() ? this.result : function.apply(this.cause);
    }

    public <X extends Throwable> T getOrElseThrow(Function<Throwable, X> function) throws X {
        if (this.isSuccess()) {
            return this.result;
        }
        throw (Throwable)function.apply(this.cause);
    }

    public Try<T> getOrElseTry(CheckedFunction<Throwable, T> function) {
        return this.isSuccess() ? this : Try.of(() -> function.apply(this.cause));
    }

    public void run() throws Throwable {
        if (this.isFailure()) {
            throw this.cause;
        }
    }

    public <X extends Throwable> void runOrThrow(Function<Throwable, X> function) throws X {
        if (this.isFailure()) {
            throw (Throwable)function.apply(this.cause);
        }
    }

    public Try(CheckedSupplier<T> supplier) {
        this.supplier = supplier;
    }

    public boolean isPerformed() {
        return this.performed;
    }
}

