/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.DefaultContainerManager;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.parser.handler.strategy.SimplePropertyMappingStrategyManager;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.ConfigurationUtil;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;

public class Crane4jApplicationContext
extends DefaultContainerManager
implements Crane4jGlobalConfiguration,
SmartInitializingSingleton,
DisposableBean,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Crane4jApplicationContext.class);
    private final ApplicationContext applicationContext;
    private final BiMap<String, String> beanNameNamespaceMapping = HashBiMap.create();
    private final PropertyMappingStrategyManager propertyMappingStrategyManager = new SimplePropertyMappingStrategyManager();
    private final Map<String, CacheManager> cacheManagerMap = new HashMap<String, CacheManager>(8);

    private static @Nullable Integer findOrderFromAnnotation(Object t) {
        if (!(t instanceof AnnotatedElement)) {
            return null;
        }
        Order annotation = (Order)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)((AnnotatedElement)t), Order.class);
        return Objects.nonNull(annotation) ? Integer.valueOf(annotation.value()) : null;
    }

    public ConverterManager getConverterManager() {
        return (ConverterManager)this.applicationContext.getBean(ConverterManager.class);
    }

    public PropertyOperator getPropertyOperator() {
        return (PropertyOperator)this.applicationContext.getBean(PropertyOperator.class);
    }

    public TypeResolver getTypeResolver() {
        return (TypeResolver)this.applicationContext.getBean(TypeResolver.class);
    }

    public <T extends ContainerProvider> @Nullable T getContainerProvider(String name) {
        ContainerProvider provider = super.getContainerProvider(name);
        return (T)(Objects.isNull(provider) && this.applicationContext.containsBean(name) ? (ContainerProvider)this.applicationContext.getBean(name, ContainerProvider.class) : provider);
    }

    public <K> @Nullable Container<K> getContainer(String namespace) {
        namespace = (String)this.beanNameNamespaceMapping.getOrDefault((Object)namespace, (Object)namespace);
        return super.getContainer(namespace);
    }

    public boolean containsContainer(String namespace) {
        return super.containsContainer(namespace) || this.applicationContext.containsBean(namespace);
    }

    public @NonNull BeanOperationExecutor getBeanOperationExecutor(@Nullable String executorName, Class<?> executorType) {
        return (BeanOperationExecutor)ConfigurationUtil.getComponentFromConfiguration(BeanOperationExecutor.class, executorType, (String)executorName, (t, n) -> (BeanOperationExecutor)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public @NonNull BeanOperationParser getBeanOperationsParser(@Nullable String parserName, Class<?> parserType) {
        return (BeanOperationParser)ConfigurationUtil.getComponentFromConfiguration(BeanOperationParser.class, parserType, (String)parserName, (t, n) -> (BeanOperationParser)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public @NonNull AssembleOperationHandler getAssembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        return (AssembleOperationHandler)ConfigurationUtil.getComponentFromConfiguration(AssembleOperationHandler.class, handlerType, (String)handlerName, (t, n) -> (AssembleOperationHandler)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public @NonNull DisassembleOperationHandler getDisassembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        return (DisassembleOperationHandler)ConfigurationUtil.getComponentFromConfiguration(DisassembleOperationHandler.class, handlerType, (String)handlerName, (t, n) -> (DisassembleOperationHandler)this.applicationContext.getBean(n, t), arg_0 -> ((ApplicationContext)this.applicationContext).getBean(arg_0));
    }

    public @NonNull CacheManager getCacheManager(String name) {
        return this.cacheManagerMap.getOrDefault(name, (CacheManager)this.applicationContext.getBean(name, CacheManager.class));
    }

    public void registerCacheManager(CacheManager cacheManager) {
        this.cacheManagerMap.put(cacheManager.getName(), cacheManager);
    }

    public @Nullable String getBeanNameByNamespace(String namespace) {
        return (String)this.beanNameNamespaceMapping.inverse().get((Object)namespace);
    }

    public @Nullable String getNamespaceByBeanName(String beanName) {
        return (String)this.beanNameNamespaceMapping.get((Object)beanName);
    }

    public KeyResolver getKeyResolver(Class<? extends KeyResolver> resolverType) {
        if (this.applicationContext.getBeanNamesForType(resolverType).length > 0) {
            return (KeyResolver)this.applicationContext.getBean(resolverType);
        }
        return (KeyResolver)this.applicationContext.getAutowireCapableBeanFactory().createBean(resolverType);
    }

    public void afterPropertiesSet() {
        this.applicationContext.getBeansOfType(ContainerLifecycleProcessor.class).forEach((name, processor) -> {
            log.info("install container lifecycle processor [{}]", name);
            this.registerContainerLifecycleProcessor((ContainerLifecycleProcessor)processor);
        });
    }

    public void afterSingletonsInstantiated() {
        this.applicationContext.getBeansOfType(ContainerLifecycleProcessor.class).forEach((name, processor) -> {
            if (this.registerContainerLifecycleProcessor((ContainerLifecycleProcessor)processor)) {
                log.info("install container lifecycle processor [{}]", name);
            }
        });
        this.applicationContext.getBeansOfType(ContainerDefinition.class).forEach((beanName, definition) -> {
            this.beanNameNamespaceMapping.put(beanName, (Object)definition.getNamespace());
            log.info("register container definition bean [{}] from spring context, actual namespace is [{}]", beanName, (Object)definition.getNamespace());
            this.registerContainer((ContainerDefinition)definition);
        });
        this.applicationContext.getBeansOfType(Container.class).forEach((beanName, container) -> {
            this.beanNameNamespaceMapping.put(beanName, (Object)container.getNamespace());
            log.info("register container bean [{}] bean from spring context, actual namespace is [{}]", beanName, (Object)container.getNamespace());
            this.registerContainer((Container)container);
        });
        this.applicationContext.getBeansOfType(ContainerProvider.class).forEach((beanName, provider) -> {
            log.info("register container provider [{}] from spring context", beanName);
            this.registerContainerProvider((String)beanName, (ContainerProvider)provider);
        });
        this.applicationContext.getBeansOfType(PropertyMappingStrategy.class).forEach((beanName, strategy) -> {
            log.info("register property mapping strategy manager [{}]({}) from spring context", beanName, strategy);
            this.propertyMappingStrategyManager.addPropertyMappingStrategy(strategy);
        });
    }

    public void destroy() {
        log.info("global configuration has been destroyed.");
        this.clear();
    }

    public Crane4jApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void addPropertyMappingStrategy(PropertyMappingStrategy arg0) {
        this.propertyMappingStrategyManager.addPropertyMappingStrategy(arg0);
    }

    public PropertyMappingStrategy getPropertyMappingStrategy(String arg0) {
        return this.propertyMappingStrategyManager.getPropertyMappingStrategy(arg0);
    }

    public PropertyMappingStrategy removePropertyMappingStrategy(String arg0) {
        return this.propertyMappingStrategyManager.removePropertyMappingStrategy(arg0);
    }

    public Collection<PropertyMappingStrategy> getAllPropertyMappingStrategies() {
        return this.propertyMappingStrategyManager.getAllPropertyMappingStrategies();
    }

    static {
        Crane4jGlobalSorter.INSTANCE.addCompareValueExtractor(t -> {
            if (Objects.isNull(t)) {
                return null;
            }
            if (t instanceof Ordered) {
                return ((Ordered)t).getOrder();
            }
            Integer order = Crane4jApplicationContext.findOrderFromAnnotation(t);
            if (Objects.isNull(order) && t instanceof DecoratingProxy) {
                order = Crane4jApplicationContext.findOrderFromAnnotation(((DecoratingProxy)t).getDecoratedClass());
            }
            return order;
        });
    }
}

