/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.annotation.Assemble;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.parser.handler.AbstractStandardAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.StringUtils;
import cn.crane4j.extension.spring.expression.SpelExpressionContext;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.expression.BeanResolver;
import org.springframework.util.StringValueResolver;

public class ValueResolveAssembleAnnotationHandler
extends AssembleAnnotationHandler
implements EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(ValueResolveAssembleAnnotationHandler.class);
    private final ExpressionEvaluator evaluator;
    private final BeanResolver beanResolver;
    private StringValueResolver embeddedValueResolver;

    public ValueResolveAssembleAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, ExpressionEvaluator evaluator, BeanResolver beanResolver, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        super(annotationFinder, globalConfiguration, Crane4jGlobalSorter.comparator(), propertyMappingStrategyManager);
        this.evaluator = evaluator;
        this.beanResolver = beanResolver;
    }

    protected String getContainerNamespace(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<Assemble> standardAnnotation) {
        Assemble annotation = (Assemble)standardAnnotation.getAnnotation();
        String namespace = this.resolveNamespace(annotation.container());
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            return "";
        }
        String providerName = this.resolveNamespace(annotation.containerProvider());
        return ContainerManager.canonicalNamespace((String)namespace, (String)providerName);
    }

    private @Nullable String resolveNamespace(String expression) {
        String namespace = Objects.isNull(this.embeddedValueResolver) ? expression : this.embeddedValueResolver.resolveStringValue(expression);
        try {
            SpelExpressionContext context = new SpelExpressionContext();
            context.setBeanResolver(this.beanResolver);
            namespace = (String)this.evaluator.execute(expression, String.class, (ExpressionContext)context);
        }
        catch (Exception e) {
            log.debug("cannot resolve container or namespace of container from expression [{}]", (Object)expression);
        }
        return namespace;
    }

    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }
}

