/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.scanner;

import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class ClassScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassScanner.class);
    public static final ClassScanner INSTANCE = new ClassScanner();
    public static final String CLASSPATH = "classpath";
    public static final String CLASS_SUFFIX = ".class";
    public static final String ALL = "*";
    public static final String ALL_RECURSIVE = "**";
    private final MetadataReaderFactory metadataReaderFactory;
    private final ResourcePatternResolver resourcePatternResolver;

    public ClassScanner() {
        this((MetadataReaderFactory)new CachingMetadataReaderFactory(), (ResourcePatternResolver)new PathMatchingResourcePatternResolver());
    }

    public Set<Class<?>> scan(String ... basePackages) {
        return this.scan(Objects::nonNull, basePackages);
    }

    public Set<Class<?>> scan(Predicate<ClassMetadata> classMetadataPredicate, String ... basePackages) {
        return Stream.of(basePackages).filter(StringUtils::isNotEmpty).map(this::resolvePath).map(path -> this.doScan((String)path, classMetadataPredicate)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private String resolvePath(String path) {
        if (!path.startsWith(CLASSPATH)) {
            path = "classpath*:" + path;
        }
        if (path.endsWith(CLASS_SUFFIX)) {
            String pathNotWithClassSuffix = path.substring(0, path.length() - CLASS_SUFFIX.length());
            return ClassUtils.packageToPath((String)pathNotWithClassSuffix) + CLASS_SUFFIX;
        }
        if ((path = ClassUtils.packageToPath((String)path)).endsWith(ALL_RECURSIVE)) {
            return path + "/*.class";
        }
        if (path.endsWith(ALL)) {
            return path + CLASS_SUFFIX;
        }
        return path + "/**/*.class";
    }

    private Set<Class<?>> doScan(String packageSearchPath, Predicate<ClassMetadata> classMetadataPredicate) {
        try {
            return Stream.of(this.resourcePatternResolver.getResources(packageSearchPath)).filter(Resource::isReadable).map(this::getMetadataReader).filter(Objects::nonNull).map(MetadataReader::getClassMetadata).filter(classMetadataPredicate).map(ClassMetadata::getClassName).map(ClassUtils::forName).collect(Collectors.toSet());
        }
        catch (IOException ex) {
            log.error("scan path [{}] failed", (Object)packageSearchPath, (Object)ex);
            return Collections.emptySet();
        }
    }

    private MetadataReader getMetadataReader(Resource resource) {
        try {
            return this.metadataReaderFactory.getMetadataReader(resource);
        }
        catch (IOException e) {
            log.error("get metadata reader from resource [{}] failed", (Object)resource, (Object)e);
            return null;
        }
    }

    public ClassScanner(MetadataReaderFactory metadataReaderFactory, ResourcePatternResolver resourcePatternResolver) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.resourcePatternResolver = resourcePatternResolver;
    }
}

