/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sign;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaSignConfig;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.exception.SaSignException;
import cn.dev33.satoken.secure.SaSecureUtil;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.Map;
import java.util.TreeMap;

public class SaSignTemplate {
    SaSignConfig signConfig;
    public static String key = "key";
    public static String timestamp = "timestamp";
    public static String nonce = "nonce";
    public static String sign = "sign";

    public SaSignConfig getSignConfig() {
        return this.signConfig;
    }

    public SaSignConfig getSignConfigOrGlobal() {
        if (this.signConfig != null) {
            return this.signConfig;
        }
        return SaManager.getConfig().getSign();
    }

    public String getSecretKey() {
        return this.getSignConfigOrGlobal().getSecretKey();
    }

    public SaSignTemplate setSignConfig(SaSignConfig signConfig) {
        this.signConfig = signConfig;
        return this;
    }

    public String joinParams(Map<String, ?> paramsMap) {
        StringBuilder sb = new StringBuilder();
        for (String key : paramsMap.keySet()) {
            Object value = paramsMap.get(key);
            if (SaFoxUtil.isEmpty(value)) continue;
            sb.append(key).append("=").append(value).append("&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String joinParamsDictSort(Map<String, ?> paramsMap) {
        if (!(paramsMap instanceof TreeMap)) {
            paramsMap = new TreeMap(paramsMap);
        }
        return this.joinParams(paramsMap);
    }

    public String createSign(Map<String, ?> paramsMap) {
        String secretKey = this.getSecretKey();
        SaSignException.throwByNull(secretKey, "\u53c2\u4e0e\u53c2\u6570\u7b7e\u540d\u7684\u79d8\u94a5\u4e0d\u53ef\u4e3a\u7a7a", 12201);
        if (paramsMap.containsKey(sign)) {
            paramsMap = new TreeMap(paramsMap);
            paramsMap.remove(sign);
        }
        String paramsStr = this.joinParamsDictSort(paramsMap);
        String fullStr = paramsStr + "&" + key + "=" + secretKey;
        return this.abstractStr(fullStr);
    }

    public String abstractStr(String fullStr) {
        return SaSecureUtil.md5(fullStr);
    }

    public Map<String, Object> addSignParams(Map<String, Object> paramsMap) {
        paramsMap.put(timestamp, String.valueOf(System.currentTimeMillis()));
        paramsMap.put(nonce, SaFoxUtil.getRandomString(32));
        paramsMap.put(sign, this.createSign(paramsMap));
        return paramsMap;
    }

    public String addSignParamsAndJoin(Map<String, Object> paramsMap) {
        paramsMap = this.addSignParams(paramsMap);
        return this.joinParams(paramsMap);
    }

    public boolean isValidTimestamp(long timestamp) {
        long allowDisparity = this.getSignConfigOrGlobal().getTimestampDisparity();
        long disparity = Math.abs(System.currentTimeMillis() - timestamp);
        return allowDisparity == -1L || disparity <= allowDisparity;
    }

    public void checkTimestamp(long timestamp) {
        if (!this.isValidTimestamp(timestamp)) {
            throw new SaSignException("timestamp \u8d85\u51fa\u5141\u8bb8\u7684\u8303\u56f4\uff1a" + timestamp).setCode(12203);
        }
    }

    public boolean isValidNonce(String nonce) {
        if (SaFoxUtil.isEmpty(nonce)) {
            return false;
        }
        String key = this.splicingNonceSaveKey(nonce);
        return SaManager.getSaTokenDao().get(key) == null;
    }

    public void checkNonce(String nonce) {
        if (SaFoxUtil.isEmpty(nonce)) {
            throw new SaSignException("nonce \u4e3a\u7a7a\uff0c\u65e0\u6548");
        }
        String key = this.splicingNonceSaveKey(nonce);
        if (SaManager.getSaTokenDao().get(key) != null) {
            throw new SaSignException("\u6b64 nonce \u5df2\u88ab\u4f7f\u7528\u8fc7\uff0c\u4e0d\u53ef\u91cd\u590d\u4f7f\u7528\uff1a" + nonce);
        }
        SaManager.getSaTokenDao().set(key, nonce, this.getSignConfigOrGlobal().getSaveNonceExpire() * 2L + 2L);
    }

    public boolean isValidSign(Map<String, ?> paramsMap, String sign) {
        String theSign = this.createSign(paramsMap);
        return theSign.equals(sign);
    }

    public void checkSign(Map<String, ?> paramsMap, String sign) {
        if (!this.isValidSign(paramsMap, sign)) {
            throw new SaSignException("\u65e0\u6548\u7b7e\u540d\uff1a" + sign).setCode(12202);
        }
    }

    public boolean isValidParamMap(Map<String, String> paramMap) {
        String timestampValue = paramMap.get(timestamp);
        String nonceValue = paramMap.get(nonce);
        String signValue = paramMap.get(sign);
        SaSignException.throwByNull(timestampValue, "\u7f3a\u5c11 timestamp \u5b57\u6bb5");
        SaSignException.throwByNull(nonceValue, "\u7f3a\u5c11 nonce \u5b57\u6bb5");
        SaSignException.throwByNull(signValue, "\u7f3a\u5c11 sign \u5b57\u6bb5");
        return this.isValidTimestamp(Long.parseLong(timestampValue)) && (this.getSignConfigOrGlobal().getIsCheckNonce() == false || this.isValidNonce(nonceValue)) && this.isValidSign(paramMap, signValue);
    }

    public void checkParamMap(Map<String, String> paramMap) {
        String timestampValue = paramMap.get(timestamp);
        String nonceValue = paramMap.get(nonce);
        String signValue = paramMap.get(sign);
        this.checkTimestamp(Long.parseLong(timestampValue));
        if (this.getSignConfigOrGlobal().getIsCheckNonce().booleanValue()) {
            this.checkNonce(nonceValue);
        }
        this.checkSign(paramMap, signValue);
    }

    public boolean isValidRequest(SaRequest request) {
        return this.isValidParamMap(request.getParamMap());
    }

    public void checkRequest(SaRequest request) {
        this.checkParamMap(request.getParamMap());
    }

    public String splicingNonceSaveKey(String nonce) {
        return SaManager.getConfig().getTokenName() + ":sign:nonce:" + nonce;
    }
}

