/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.httpauth.basic;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.exception.NotBasicAuthException;
import cn.dev33.satoken.secure.SaBase64Util;
import cn.dev33.satoken.util.SaFoxUtil;

public class SaHttpBasicTemplate {
    public static final String DEFAULT_REALM = "Sa-Token";

    public void throwNotBasicAuthException(String realm) {
        SaHolder.getResponse().setStatus(401).setHeader("WWW-Authenticate", "Basic Realm=" + realm);
        throw new NotBasicAuthException().setCode(10311);
    }

    public String getAuthorizationValue() {
        String authorization = SaHolder.getRequest().getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Basic ")) {
            return null;
        }
        return SaBase64Util.decode(authorization.substring(6));
    }

    public void check() {
        this.check(DEFAULT_REALM, SaManager.getConfig().getHttpBasic());
    }

    public void check(String account) {
        this.check(DEFAULT_REALM, account);
    }

    public void check(String realm, String account) {
        String authorization;
        if (SaFoxUtil.isEmpty(account)) {
            account = SaManager.getConfig().getHttpBasic();
        }
        if (SaFoxUtil.isEmpty(authorization = this.getAuthorizationValue()) || !authorization.equals(account)) {
            this.throwNotBasicAuthException(realm);
        }
    }
}

