/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.annotation.handler;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaMode;
import cn.dev33.satoken.annotation.handler.SaAnnotationHandlerInterface;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import java.lang.reflect.Method;

public class SaCheckPermissionHandler
implements SaAnnotationHandlerInterface<SaCheckPermission> {
    @Override
    public Class<SaCheckPermission> getHandlerAnnotationClass() {
        return SaCheckPermission.class;
    }

    @Override
    public void checkMethod(SaCheckPermission at, Method method) {
        SaCheckPermissionHandler._checkMethod(at.type(), at.value(), at.mode(), at.orRole());
    }

    public static void _checkMethod(String type, String[] value, SaMode mode, String[] orRole) {
        StpLogic stpLogic = SaManager.getStpLogic(type, false);
        String[] permissionArray = value;
        try {
            if (mode == SaMode.AND) {
                stpLogic.checkPermissionAnd(permissionArray);
            } else {
                stpLogic.checkPermissionOr(permissionArray);
            }
        }
        catch (NotPermissionException e) {
            for (String role : orRole) {
                String[] rArr = SaFoxUtil.convertStringToArray(role);
                if (!stpLogic.hasRoleAnd(rArr)) continue;
                return;
            }
            throw e;
        }
    }
}

