/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.apikey;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.apikey.model.ApiKeyModel;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.ApiKeyException;
import cn.dev33.satoken.exception.ApiKeyScopeException;
import cn.dev33.satoken.httpauth.basic.SaHttpBasicUtil;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.raw.SaRawSessionDelegator;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.List;

public class SaApiKeyTemplate {
    public static final String DEFAULT_NAMESPACE = "apikey";
    public String namespace;
    public SaRawSessionDelegator rawSessionDelegator;
    public static final String API_KEY_LIST = "__HD_API_KEY_LIST";

    public SaApiKeyTemplate() {
        this(DEFAULT_NAMESPACE);
    }

    public SaApiKeyTemplate(String namespace) {
        if (SaFoxUtil.isEmpty(namespace)) {
            throw new ApiKeyException("namespace \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.namespace = namespace;
        this.rawSessionDelegator = new SaRawSessionDelegator(namespace);
    }

    public ApiKeyModel getApiKeyModelFromCache(String apiKey) {
        return this.getSaTokenDao().getObject(this.splicingApiKeySaveKey(apiKey), ApiKeyModel.class);
    }

    public ApiKeyModel getApiKeyModelFromDatabase(String apiKey) {
        return SaManager.getSaApiKeyDataLoader().getApiKeyModelFromDatabase(this.namespace, apiKey);
    }

    public ApiKeyModel getApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        ApiKeyModel apiKeyModel = this.getApiKeyModelFromCache(apiKey);
        if (apiKeyModel == null) {
            apiKeyModel = this.getApiKeyModelFromDatabase(apiKey);
            this.saveApiKey(apiKeyModel);
        }
        return apiKeyModel;
    }

    public ApiKeyModel checkApiKey(String apiKey) {
        ApiKeyModel ak = this.getApiKey(apiKey);
        if (ak == null) {
            throw new ApiKeyException("\u65e0\u6548 API Key: " + apiKey).setApiKey(apiKey).setCode(12301);
        }
        if (ak.timeExpired()) {
            throw new ApiKeyException("API Key \u5df2\u8fc7\u671f: " + apiKey).setApiKey(apiKey).setCode(12302);
        }
        if (!ak.getIsValid().booleanValue()) {
            throw new ApiKeyException("API Key \u5df2\u88ab\u7981\u7528: " + apiKey).setApiKey(apiKey).setCode(12303);
        }
        return ak;
    }

    public void saveApiKey(ApiKeyModel ak) {
        if (ak == null) {
            return;
        }
        ak.checkByCanSaved();
        String saveKey = this.splicingApiKeySaveKey(ak.getApiKey());
        if (ak.timeExpired()) {
            this.getSaTokenDao().deleteObject(saveKey);
        } else {
            this.getSaTokenDao().setObject(saveKey, ak, ak.expiresIn());
        }
        if (this.getIsRecordIndex()) {
            SaSession session = this.rawSessionDelegator.getSessionById(ak.getLoginId());
            ArrayList apiKeyList = session.get(API_KEY_LIST, ArrayList::new);
            if (!apiKeyList.contains(ak.getApiKey())) {
                apiKeyList.add(ak.getApiKey());
                session.set(API_KEY_LIST, apiKeyList);
            }
            this.adjustIndex(ak.getLoginId(), session);
        }
    }

    public Object getLoginIdByApiKey(String apiKey) {
        return this.checkApiKey(apiKey).getLoginId();
    }

    public void deleteApiKey(String apiKey) {
        ApiKeyModel ak = this.getApiKeyModelFromCache(apiKey);
        if (ak == null) {
            return;
        }
        this.getSaTokenDao().deleteObject(this.splicingApiKeySaveKey(apiKey));
        if (this.getIsRecordIndex()) {
            SaSession session = this.rawSessionDelegator.getSessionById(ak.getLoginId(), false);
            if (session == null) {
                return;
            }
            ArrayList apiKeyList = session.get(API_KEY_LIST, ArrayList::new);
            if (!apiKeyList.contains(apiKey)) {
                return;
            }
            if (apiKeyList.size() == 1) {
                this.rawSessionDelegator.deleteSessionById(ak.getLoginId());
            } else {
                apiKeyList.remove(apiKey);
                session.set(API_KEY_LIST, apiKeyList);
            }
        }
    }

    public void deleteApiKeyByLoginId(Object loginId) {
        if (!this.getIsRecordIndex()) {
            SaManager.getLog().warn("\u5f53\u524d API Key \u6a21\u5757\u672a\u5f00\u542f\u7d22\u5f15\u8bb0\u5f55\u529f\u80fd\uff0c\u65e0\u6cd5\u6267\u884c deleteApiKeyByLoginId \u64cd\u4f5c", new Object[0]);
            return;
        }
        SaSession session = this.rawSessionDelegator.getSessionById(loginId, false);
        if (session == null) {
            return;
        }
        ArrayList apiKeyList = session.get(API_KEY_LIST, ArrayList::new);
        for (String apiKey : apiKeyList) {
            this.getSaTokenDao().deleteObject(this.splicingApiKeySaveKey(apiKey));
        }
        this.rawSessionDelegator.deleteSessionById(loginId);
    }

    public ApiKeyModel createApiKeyModel() {
        String apiKey = SaStrategy.instance.generateUniqueToken.execute("API Key", SaManager.getConfig().getMaxTryTimes(), this::randomApiKeyValue, _apiKey -> this.getApiKey((String)_apiKey) == null);
        return new ApiKeyModel().setApiKey(apiKey);
    }

    public ApiKeyModel createApiKeyModel(Object loginId) {
        long timeout = SaManager.getConfig().getApiKey().getTimeout();
        long expiresTime = timeout == -1L ? -1L : System.currentTimeMillis() + timeout * 1000L;
        return this.createApiKeyModel().setLoginId(loginId).setIsValid(true).setExpiresTime(expiresTime);
    }

    public String randomApiKeyValue() {
        return SaManager.getConfig().getApiKey().getPrefix() + SaFoxUtil.getRandomString(36);
    }

    public boolean hasApiKeyScope(String apiKey, String ... scopes) {
        try {
            this.checkApiKeyScope(apiKey, scopes);
            return true;
        }
        catch (ApiKeyException e) {
            return false;
        }
    }

    public void checkApiKeyScope(String apiKey, String ... scopes) {
        ApiKeyModel ak = this.checkApiKey(apiKey);
        if (SaFoxUtil.isEmptyArray(scopes)) {
            return;
        }
        for (String scope : scopes) {
            if (ak.getScopes().contains(scope)) continue;
            throw new ApiKeyScopeException("\u8be5 API Key \u4e0d\u5177\u5907 Scope\uff1a" + scope).setApiKey(apiKey).setScope(scope).setCode(12311);
        }
    }

    public boolean hasApiKeyScopeOr(String apiKey, String ... scopes) {
        try {
            this.checkApiKeyScopeOr(apiKey, scopes);
            return true;
        }
        catch (ApiKeyException e) {
            return false;
        }
    }

    public void checkApiKeyScopeOr(String apiKey, String ... scopes) {
        ApiKeyModel ak = this.checkApiKey(apiKey);
        if (SaFoxUtil.isEmptyArray(scopes)) {
            return;
        }
        for (String scope : scopes) {
            if (!ak.getScopes().contains(scope)) continue;
            return;
        }
        throw new ApiKeyScopeException("\u8be5 API Key \u4e0d\u5177\u5907 Scope\uff1a" + scopes[0]).setApiKey(apiKey).setScope(scopes[0]).setCode(12311);
    }

    public boolean isApiKeyLoginId(String apiKey, Object loginId) {
        try {
            this.checkApiKeyLoginId(apiKey, loginId);
            return true;
        }
        catch (ApiKeyException e) {
            return false;
        }
    }

    public void checkApiKeyLoginId(String apiKey, Object loginId) {
        ApiKeyModel ak = this.getApiKey(apiKey);
        if (ak == null) {
            throw new ApiKeyException("\u65e0\u6548 API Key: " + apiKey).setApiKey(apiKey).setCode(12301);
        }
        if (SaFoxUtil.notEquals(String.valueOf(ak.getLoginId()), String.valueOf(loginId))) {
            throw new ApiKeyException("\u8be5 API Key \u4e0d\u5c5e\u4e8e\u7528\u6237: " + loginId).setApiKey(apiKey).setCode(12312);
        }
    }

    public void adjustIndex(Object loginId, SaSession session) {
        if (!this.getIsRecordIndex()) {
            SaManager.getLog().warn("\u5f53\u524d API Key \u6a21\u5757\u672a\u5f00\u542f\u7d22\u5f15\u8bb0\u5f55\u529f\u80fd\uff0c\u65e0\u6cd5\u6267\u884c adjustIndex \u64cd\u4f5c", new Object[0]);
            return;
        }
        if (session == null && (session = this.rawSessionDelegator.getSessionById(loginId, false)) == null) {
            return;
        }
        ArrayList apiKeyList = session.get(API_KEY_LIST, ArrayList::new);
        ArrayList<String> apiKeyNewList = new ArrayList<String>();
        ArrayList<ApiKeyModel> apiKeyModelList = new ArrayList<ApiKeyModel>();
        for (String apikey : apiKeyList) {
            ApiKeyModel ak = this.getApiKeyModelFromCache(apikey);
            if (ak == null || ak.timeExpired()) continue;
            apiKeyNewList.add(apikey);
            apiKeyModelList.add(ak);
        }
        if (apiKeyNewList.isEmpty()) {
            this.rawSessionDelegator.deleteSessionById(loginId);
            return;
        }
        session.set(API_KEY_LIST, apiKeyNewList);
        long maxTtl = 0L;
        for (ApiKeyModel ak : apiKeyModelList) {
            long ttl = ak.expiresIn();
            if (ttl == -1L) {
                maxTtl = -1L;
                break;
            }
            if (ttl <= maxTtl) continue;
            maxTtl = ttl;
        }
        if (maxTtl != 0L) {
            session.updateTimeout(maxTtl);
        }
    }

    public List<ApiKeyModel> getApiKeyList(Object loginId) {
        if (!this.getIsRecordIndex()) {
            SaManager.getLog().warn("\u5f53\u524d API Key \u6a21\u5757\u672a\u5f00\u542f\u7d22\u5f15\u8bb0\u5f55\u529f\u80fd\uff0c\u65e0\u6cd5\u6267\u884c getApiKeyList \u64cd\u4f5c", new Object[0]);
            return new ArrayList<ApiKeyModel>();
        }
        ArrayList<ApiKeyModel> apiKeyModelList = new ArrayList<ApiKeyModel>();
        SaSession session = this.rawSessionDelegator.getSessionById(loginId, false);
        if (session == null) {
            return apiKeyModelList;
        }
        ArrayList apiKeyList = session.get(API_KEY_LIST, ArrayList::new);
        for (String apikey : apiKeyList) {
            ApiKeyModel ak = this.getApiKeyModelFromCache(apikey);
            if (ak == null || ak.timeExpired()) continue;
            apiKeyModelList.add(ak);
        }
        return apiKeyModelList;
    }

    public String readApiKeyValue(SaRequest request) {
        String apiKey = request.getParam(this.namespace);
        if (SaFoxUtil.isNotEmpty(apiKey)) {
            return apiKey;
        }
        apiKey = request.getHeader(this.namespace);
        if (SaFoxUtil.isNotEmpty(apiKey)) {
            return apiKey;
        }
        apiKey = SaHttpBasicUtil.getAuthorizationValue();
        if (SaFoxUtil.isNotEmpty(apiKey)) {
            if (apiKey.endsWith(":")) {
                apiKey = apiKey.substring(0, apiKey.length() - 1);
            }
            return apiKey;
        }
        return null;
    }

    public ApiKeyModel currentApiKey() {
        String readApiKeyValue = this.readApiKeyValue(SaHolder.getRequest());
        return this.checkApiKey(readApiKeyValue);
    }

    public String splicingApiKeySaveKey(String apiKey) {
        return this.getSaTokenConfig().getTokenName() + ":" + this.namespace + ":" + apiKey;
    }

    public SaTokenDao getSaTokenDao() {
        return SaManager.getSaTokenDao();
    }

    public SaTokenConfig getSaTokenConfig() {
        return SaManager.getConfig();
    }

    public boolean getIsRecordIndex() {
        return SaManager.getSaApiKeyDataLoader().getIsRecordIndex();
    }
}

