/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.context;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.context.model.SaStorage;
import cn.dev33.satoken.context.model.SaTokenContextModelBox;
import cn.dev33.satoken.exception.SaTokenContextException;

public class SaTokenContextForThreadLocalStaff {
    public static ThreadLocal<SaTokenContextModelBox> modelBoxThreadLocal = new ThreadLocal();

    public static void setModelBox(SaRequest request, SaResponse response, SaStorage storage) {
        SaTokenContextModelBox bok = new SaTokenContextModelBox(request, response, storage);
        modelBoxThreadLocal.set(bok);
    }

    public static void clearModelBox() {
        modelBoxThreadLocal.remove();
    }

    public static SaTokenContextModelBox getModelBoxOrNull() {
        return modelBoxThreadLocal.get();
    }

    public static SaTokenContextModelBox getModelBox() {
        SaTokenContextModelBox box = modelBoxThreadLocal.get();
        if (box == null) {
            throw new SaTokenContextException("SaTokenContext \u4e0a\u4e0b\u6587\u5c1a\u672a\u521d\u59cb\u5316").setCode(10002);
        }
        return box;
    }

    public static SaRequest getRequest() {
        return SaTokenContextForThreadLocalStaff.getModelBox().getRequest();
    }

    public static SaResponse getResponse() {
        return SaTokenContextForThreadLocalStaff.getModelBox().getResponse();
    }

    public static SaStorage getStorage() {
        return SaTokenContextForThreadLocalStaff.getModelBox().getStorage();
    }
}

