/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.secure;

import java.nio.charset.StandardCharsets;

public class SaBase32Util {
    private static final String BASE32_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] BASE32_LOOKUP = new int[256];

    public static String encodeBytesToString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int buffer = 0;
        int bufferSize = 0;
        for (byte b : bytes) {
            buffer = buffer << 8 | b & 0xFF;
            bufferSize += 8;
            while (bufferSize >= 5) {
                int index = buffer >> (bufferSize -= 5) & 0x1F;
                result.append(BASE32_CHARS.charAt(index));
            }
        }
        if (bufferSize > 0) {
            int index = buffer << 5 - bufferSize & 0x1F;
            result.append(BASE32_CHARS.charAt(index));
        }
        return result.toString();
    }

    public static byte[] decodeStringToBytes(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.replaceAll("=", "").trim()).isEmpty()) {
            return new byte[0];
        }
        int buffer = 0;
        int bufferSize = 0;
        int byteCount = (text.length() * 5 + 7) / 8;
        byte[] bytes = new byte[byteCount];
        int byteIndex = 0;
        for (char c : text.toCharArray()) {
            int value = BASE32_LOOKUP[c];
            if (value == 0 && c != 'A') continue;
            buffer = buffer << 5 | value;
            if ((bufferSize += 5) < 8) continue;
            bytes[byteIndex++] = (byte)(buffer >> (bufferSize -= 8) & 0xFF);
        }
        if (bufferSize > 0) {
            bytes[byteIndex] = (byte)(buffer << 8 - bufferSize & 0xFF);
        }
        return bytes;
    }

    public static String encode(String text) {
        if (text == null) {
            return null;
        }
        return SaBase32Util.encodeBytesToString(text.getBytes(StandardCharsets.UTF_8));
    }

    public static String decode(String base32Text) {
        if (base32Text == null) {
            return null;
        }
        byte[] bytes = SaBase32Util.decodeStringToBytes(base32Text);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static {
        for (int i = 0; i < BASE32_CHARS.length(); ++i) {
            char c = BASE32_CHARS.charAt(i);
            SaBase32Util.BASE32_LOOKUP[c] = i;
            if (c < 'A' || c > 'Z') continue;
            SaBase32Util.BASE32_LOOKUP[Character.toLowerCase((char)c)] = i;
        }
    }
}

