/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.listener;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.handler.SaAnnotationHandlerInterface;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.listener.SaTokenListener;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.util.SaFoxUtil;

public class SaTokenListenerForLog
implements SaTokenListener {
    @Override
    public void doLogin(String loginType, Object loginId, String tokenValue, SaLoginParameter loginParameter) {
        SaManager.log.info("\u8d26\u53f7 {} \u767b\u5f55\u6210\u529f (loginType={}), \u4f1a\u8bdd\u51ed\u8bc1 token={}", loginId, loginType, tokenValue);
    }

    @Override
    public void doLogout(String loginType, Object loginId, String tokenValue) {
        SaManager.log.info("\u8d26\u53f7 {} \u6ce8\u9500\u767b\u5f55 (loginType={}), \u4f1a\u8bdd\u51ed\u8bc1 token={}", loginId, loginType, tokenValue);
    }

    @Override
    public void doKickout(String loginType, Object loginId, String tokenValue) {
        SaManager.log.info("\u8d26\u53f7 {} \u88ab\u8e22\u4e0b\u7ebf (loginType={}), \u4f1a\u8bdd\u51ed\u8bc1 token={}", loginId, loginType, tokenValue);
    }

    @Override
    public void doReplaced(String loginType, Object loginId, String tokenValue) {
        SaManager.log.info("\u8d26\u53f7 {} \u88ab\u9876\u4e0b\u7ebf (loginType={}), \u4f1a\u8bdd\u51ed\u8bc1 token={}", loginId, loginType, tokenValue);
    }

    @Override
    public void doDisable(String loginType, Object loginId, String service, int level, long disableTime) {
        SaManager.log.info("\u8d26\u53f7 {} [{}\u670d\u52a1] \u88ab\u5c01\u7981 (loginType={}), \u5c01\u7981\u7b49\u7ea7={}, \u89e3\u5c01\u65f6\u95f4\u4e3a {}", loginId, loginType, service, level, SaFoxUtil.formatAfterDate(disableTime * 1000L));
    }

    @Override
    public void doUntieDisable(String loginType, Object loginId, String service) {
        SaManager.log.info("\u8d26\u53f7 {} [{}\u670d\u52a1] \u89e3\u5c01\u6210\u529f (loginType={})", loginId, service, loginType);
    }

    @Override
    public void doOpenSafe(String loginType, String tokenValue, String service, long safeTime) {
        SaManager.log.info("token \u4e8c\u7ea7\u8ba4\u8bc1\u6210\u529f, \u4e1a\u52a1\u6807\u8bc6={}, \u6709\u6548\u671f={}\u79d2, Token\u503c={}", service, safeTime, tokenValue);
    }

    @Override
    public void doCloseSafe(String loginType, String tokenValue, String service) {
        SaManager.log.info("token \u4e8c\u7ea7\u8ba4\u8bc1\u5173\u95ed, \u4e1a\u52a1\u6807\u8bc6={}, Token\u503c={}", service, tokenValue);
    }

    @Override
    public void doCreateSession(String id) {
        SaManager.log.info("SaSession [{}] \u521b\u5efa\u6210\u529f", id);
    }

    @Override
    public void doLogoutSession(String id) {
        SaManager.log.info("SaSession [{}] \u6ce8\u9500\u6210\u529f", id);
    }

    @Override
    public void doRenewTimeout(String loginType, Object loginId, String tokenValue, long timeout) {
        SaManager.log.info("token \u7eed\u671f\u6210\u529f, {} \u79d2\u540e\u5230\u671f, \u5e10\u53f7={}, token\u503c={} ", timeout, loginId, tokenValue);
    }

    @Override
    public void doRegisterComponent(String compName, Object compObj) {
        String canonicalName = compObj == null ? null : compObj.getClass().getCanonicalName();
        SaManager.log.info("\u5168\u5c40\u7ec4\u4ef6 {} \u8f7d\u5165\u6210\u529f: {}", compName, canonicalName);
    }

    @Override
    public void doRegisterAnnotationHandler(SaAnnotationHandlerInterface<?> handler) {
        if (handler != null) {
            SaManager.log.info("\u6ce8\u89e3\u6269\u5c55 @{} (\u5904\u7406\u5668: {})", handler.getHandlerAnnotationClass().getSimpleName(), handler.getClass().getCanonicalName());
        }
    }

    @Override
    public void doSetStpLogic(StpLogic stpLogic) {
        if (stpLogic != null) {
            SaManager.log.info("\u4f1a\u8bdd\u7ec4\u4ef6 StpLogic(type={}) \u91cd\u7f6e\u6210\u529f: {}", stpLogic.getLoginType(), stpLogic.getClass());
        }
    }

    @Override
    public void doSetConfig(SaTokenConfig config) {
        if (config != null) {
            SaManager.log.info("\u5168\u5c40\u914d\u7f6e {} ", config);
        }
    }
}

