/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class AccessTokenModel
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String accessToken;
    public String refreshToken;
    public long expiresTime;
    public long refreshExpiresTime;
    public String clientId;
    public Object loginId;
    public List<String> scopes;
    public String tokenType;
    public Map<String, Object> extraData;

    public AccessTokenModel() {
    }

    public AccessTokenModel(String accessToken, String clientId, Object loginId, List<String> scopes) {
        this.accessToken = accessToken;
        this.clientId = clientId;
        this.loginId = loginId;
        this.scopes = scopes;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public AccessTokenModel setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public AccessTokenModel setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public long getExpiresTime() {
        return this.expiresTime;
    }

    public AccessTokenModel setExpiresTime(long expiresTime) {
        this.expiresTime = expiresTime;
        return this;
    }

    public long getRefreshExpiresTime() {
        return this.refreshExpiresTime;
    }

    public AccessTokenModel setRefreshExpiresTime(long refreshExpiresTime) {
        this.refreshExpiresTime = refreshExpiresTime;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public AccessTokenModel setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public Object getLoginId() {
        return this.loginId;
    }

    public AccessTokenModel setLoginId(Object loginId) {
        this.loginId = loginId;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public AccessTokenModel setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public AccessTokenModel setTokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public AccessTokenModel setExtraData(Map<String, Object> extraData) {
        this.extraData = extraData;
        return this;
    }

    public String toString() {
        return "AccessTokenModel{accessToken='" + this.accessToken + '\'' + ", refreshToken='" + this.refreshToken + '\'' + ", expiresTime=" + this.expiresTime + ", refreshExpiresTime=" + this.refreshExpiresTime + ", clientId='" + this.clientId + '\'' + ", loginId=" + this.loginId + ", scopes=" + this.scopes + ", tokenType='" + this.tokenType + '\'' + ", extraData=" + this.extraData + '}';
    }

    public long getExpiresIn() {
        long s = (this.expiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public long getRefreshExpiresIn() {
        long s = (this.refreshExpiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }
}

