/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.convert;

import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.consts.GrantType;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.convert.SaOAuth2DataConverter;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.strategy.SaOAuth2Strategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class SaOAuth2DataConverterDefaultImpl
implements SaOAuth2DataConverter {
    @Override
    public List<String> convertScopeStringToList(String scopeString) {
        if (SaFoxUtil.isEmpty((Object)scopeString)) {
            return new ArrayList<String>();
        }
        scopeString = scopeString.replaceAll(" ", ",");
        scopeString = scopeString.replaceAll("%20", ",");
        return SaFoxUtil.convertStringToList((String)scopeString);
    }

    @Override
    public String convertScopeListToString(List<String> scopeList) {
        return SaFoxUtil.convertListToString(scopeList);
    }

    @Override
    public List<String> convertRedirectUriStringToList(String redirectUris) {
        if (SaFoxUtil.isEmpty((Object)redirectUris)) {
            return new ArrayList<String>();
        }
        return SaFoxUtil.convertStringToList((String)redirectUris);
    }

    @Override
    public AccessTokenModel convertCodeToAccessToken(CodeModel cm) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = SaOAuth2Strategy.instance.createAccessToken.execute(cm.clientId, cm.loginId, cm.scopes);
        at.clientId = cm.clientId;
        at.loginId = cm.loginId;
        at.scopes = cm.scopes;
        at.tokenType = SaOAuth2Consts.TokenType.bearer;
        at.grantType = GrantType.authorization_code;
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(cm.clientId);
        at.expiresTime = System.currentTimeMillis() + clientModel.getAccessTokenTimeout() * 1000L;
        at.extraData = new LinkedHashMap<String, Object>();
        return at;
    }

    @Override
    public RefreshTokenModel convertAccessTokenToRefreshToken(AccessTokenModel at) {
        RefreshTokenModel rt = new RefreshTokenModel();
        rt.refreshToken = SaOAuth2Strategy.instance.createRefreshToken.execute(at.clientId, at.loginId, at.scopes);
        rt.clientId = at.clientId;
        rt.loginId = at.loginId;
        rt.scopes = at.scopes;
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(at.clientId);
        rt.expiresTime = System.currentTimeMillis() + clientModel.getRefreshTokenTimeout() * 1000L;
        rt.extraData = new LinkedHashMap<String, Object>(at.extraData);
        return rt;
    }

    @Override
    public AccessTokenModel convertRefreshTokenToAccessToken(RefreshTokenModel rt) {
        AccessTokenModel at = new AccessTokenModel();
        at.accessToken = SaOAuth2Strategy.instance.createAccessToken.execute(rt.clientId, rt.loginId, rt.scopes);
        at.refreshToken = rt.refreshToken;
        at.clientId = rt.clientId;
        at.loginId = rt.loginId;
        at.scopes = rt.scopes;
        at.tokenType = SaOAuth2Consts.TokenType.bearer;
        at.grantType = GrantType.refresh_token;
        at.extraData = new LinkedHashMap<String, Object>(rt.extraData);
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(rt.clientId);
        at.expiresTime = System.currentTimeMillis() + clientModel.getAccessTokenTimeout() * 1000L;
        at.refreshExpiresTime = rt.expiresTime;
        return at;
    }

    @Override
    public RefreshTokenModel convertRefreshTokenToRefreshToken(RefreshTokenModel rt) {
        RefreshTokenModel newRt = new RefreshTokenModel();
        newRt.refreshToken = SaOAuth2Strategy.instance.createRefreshToken.execute(rt.clientId, rt.loginId, rt.scopes);
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(rt.clientId);
        newRt.expiresTime = System.currentTimeMillis() + clientModel.getRefreshTokenTimeout() * 1000L;
        newRt.clientId = rt.clientId;
        newRt.scopes = rt.scopes;
        newRt.loginId = rt.loginId;
        newRt.extraData = new LinkedHashMap<String, Object>(rt.extraData);
        return newRt;
    }
}

