/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.config;

import cn.dev33.satoken.oauth2.config.SaOAuth2OidcConfig;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class SaOAuth2ServerConfig
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public Boolean enableAuthorizationCode = true;
    public Boolean enableImplicit = true;
    public Boolean enablePassword = true;
    public Boolean enableClientCredentials = true;
    public long codeTimeout = 300L;
    public long accessTokenTimeout = 7200L;
    public long refreshTokenTimeout = 2592000L;
    public long clientTokenTimeout = 7200L;
    public int maxAccessTokenCount = 12;
    public int maxRefreshTokenCount = 12;
    public int maxClientTokenCount = 12;
    public Boolean isNewRefresh = false;
    public String openidDigestPrefix = "openid_default_digest_prefix";
    public String unionidDigestPrefix = "unionid_default_digest_prefix";
    public String higherScope;
    public String lowerScope;
    public Boolean mode4ReturnAccessToken = false;
    public Boolean hideStatusField = false;
    SaOAuth2OidcConfig oidc = new SaOAuth2OidcConfig();
    public Map<String, SaClientModel> clients = new LinkedHashMap<String, SaClientModel>();

    public SaOAuth2ServerConfig addClient(SaClientModel client) {
        if (this.clients == null) {
            this.clients = new LinkedHashMap<String, SaClientModel>();
        }
        this.clients.put(client.getClientId(), client);
        return this;
    }

    public Boolean getEnableAuthorizationCode() {
        return this.enableAuthorizationCode;
    }

    public SaOAuth2ServerConfig setEnableAuthorizationCode(Boolean enableAuthorizationCode) {
        this.enableAuthorizationCode = enableAuthorizationCode;
        return this;
    }

    public Boolean getEnableImplicit() {
        return this.enableImplicit;
    }

    public SaOAuth2ServerConfig setEnableImplicit(Boolean enableImplicit) {
        this.enableImplicit = enableImplicit;
        return this;
    }

    public Boolean getEnablePassword() {
        return this.enablePassword;
    }

    public SaOAuth2ServerConfig setEnablePassword(Boolean enablePassword) {
        this.enablePassword = enablePassword;
        return this;
    }

    public Boolean getEnableClientCredentials() {
        return this.enableClientCredentials;
    }

    public SaOAuth2ServerConfig setEnableClientCredentials(Boolean enableClientCredentials) {
        this.enableClientCredentials = enableClientCredentials;
        return this;
    }

    public Boolean getIsNewRefresh() {
        return this.isNewRefresh;
    }

    public SaOAuth2ServerConfig setIsNewRefresh(Boolean isNewRefresh) {
        this.isNewRefresh = isNewRefresh;
        return this;
    }

    public long getCodeTimeout() {
        return this.codeTimeout;
    }

    public SaOAuth2ServerConfig setCodeTimeout(long codeTimeout) {
        this.codeTimeout = codeTimeout;
        return this;
    }

    public long getAccessTokenTimeout() {
        return this.accessTokenTimeout;
    }

    public SaOAuth2ServerConfig setAccessTokenTimeout(long accessTokenTimeout) {
        this.accessTokenTimeout = accessTokenTimeout;
        return this;
    }

    public long getRefreshTokenTimeout() {
        return this.refreshTokenTimeout;
    }

    public SaOAuth2ServerConfig setRefreshTokenTimeout(long refreshTokenTimeout) {
        this.refreshTokenTimeout = refreshTokenTimeout;
        return this;
    }

    public long getClientTokenTimeout() {
        return this.clientTokenTimeout;
    }

    public SaOAuth2ServerConfig setClientTokenTimeout(long clientTokenTimeout) {
        this.clientTokenTimeout = clientTokenTimeout;
        return this;
    }

    public int getMaxAccessTokenCount() {
        return this.maxAccessTokenCount;
    }

    public SaOAuth2ServerConfig setMaxAccessTokenCount(int maxAccessTokenCount) {
        this.maxAccessTokenCount = maxAccessTokenCount;
        return this;
    }

    public int getMaxRefreshTokenCount() {
        return this.maxRefreshTokenCount;
    }

    public SaOAuth2ServerConfig setMaxRefreshTokenCount(int maxRefreshTokenCount) {
        this.maxRefreshTokenCount = maxRefreshTokenCount;
        return this;
    }

    public int getMaxClientTokenCount() {
        return this.maxClientTokenCount;
    }

    public SaOAuth2ServerConfig setMaxClientTokenCount(int maxClientTokenCount) {
        this.maxClientTokenCount = maxClientTokenCount;
        return this;
    }

    public String getOpenidDigestPrefix() {
        return this.openidDigestPrefix;
    }

    public SaOAuth2ServerConfig setOpenidDigestPrefix(String openidDigestPrefix) {
        this.openidDigestPrefix = openidDigestPrefix;
        return this;
    }

    public String getUnionidDigestPrefix() {
        return this.unionidDigestPrefix;
    }

    public SaOAuth2ServerConfig setUnionidDigestPrefix(String unionidDigestPrefix) {
        this.unionidDigestPrefix = unionidDigestPrefix;
        return this;
    }

    public String getHigherScope() {
        return this.higherScope;
    }

    public SaOAuth2ServerConfig setHigherScope(String higherScope) {
        this.higherScope = higherScope;
        return this;
    }

    public String getLowerScope() {
        return this.lowerScope;
    }

    public SaOAuth2ServerConfig setLowerScope(String lowerScope) {
        this.lowerScope = lowerScope;
        return this;
    }

    public Boolean getMode4ReturnAccessToken() {
        return this.mode4ReturnAccessToken;
    }

    public SaOAuth2ServerConfig setMode4ReturnAccessToken(Boolean mode4ReturnAccessToken) {
        this.mode4ReturnAccessToken = mode4ReturnAccessToken;
        return this;
    }

    public Boolean getHideStatusField() {
        return this.hideStatusField;
    }

    public SaOAuth2ServerConfig setHideStatusField(Boolean hideStatusField) {
        this.hideStatusField = hideStatusField;
        return this;
    }

    public SaOAuth2OidcConfig getOidc() {
        return this.oidc;
    }

    public SaOAuth2ServerConfig setOidc(SaOAuth2OidcConfig oidc) {
        this.oidc = oidc;
        return this;
    }

    public Map<String, SaClientModel> getClients() {
        return this.clients;
    }

    public SaOAuth2ServerConfig setClients(Map<String, SaClientModel> clients) {
        this.clients = clients;
        return this;
    }

    public String toString() {
        return "SaOAuth2ServerConfig {enableAuthorizationCode=" + this.enableAuthorizationCode + ", enableImplicit=" + this.enableImplicit + ", enablePassword=" + this.enablePassword + ", enableClientCredentials=" + this.enableClientCredentials + ", isNewRefresh=" + this.isNewRefresh + ", codeTimeout=" + this.codeTimeout + ", accessTokenTimeout=" + this.accessTokenTimeout + ", refreshTokenTimeout=" + this.refreshTokenTimeout + ", clientTokenTimeout=" + this.clientTokenTimeout + ", maxAccessTokenCount=" + this.maxAccessTokenCount + ", maxRefreshTokenCount=" + this.maxRefreshTokenCount + ", maxClientTokenCount=" + this.maxClientTokenCount + ", openidDigestPrefix=" + this.openidDigestPrefix + ", unionidDigestPrefix=" + this.unionidDigestPrefix + ", higherScope=" + this.higherScope + ", lowerScope=" + this.lowerScope + ", mode4ReturnAccessToken=" + this.mode4ReturnAccessToken + ", hideStatusField=" + this.hideStatusField + ", oidc=" + this.oidc + ", clients=" + this.clients + '}';
    }
}

