/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.model.loader;

import cn.dev33.satoken.oauth2.strategy.SaOAuth2Strategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SaClientModel
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String clientId;
    public String clientSecret;
    public List<String> contractScopes = new ArrayList<String>();
    public List<String> allowRedirectUris = new ArrayList<String>();
    public List<String> allowGrantTypes = new ArrayList<String>();
    public String subjectId;
    public long accessTokenTimeout;
    public long refreshTokenTimeout;
    public long clientTokenTimeout;
    public int maxAccessTokenCount;
    public int maxRefreshTokenCount;
    public int maxClientTokenCount;
    public Boolean isNewRefresh;
    public Boolean isAutoConfirm = false;

    public SaClientModel() {
        SaOAuth2Strategy.instance.setSaClientModelDefaultFields.run((Object)this);
    }

    public SaClientModel(String clientId, String clientSecret, List<String> contractScopes, List<String> allowRedirectUris) {
        this();
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.contractScopes = contractScopes;
        this.allowRedirectUris = allowRedirectUris;
    }

    public SaClientModel addContractScopes(String ... scopes) {
        if (this.contractScopes == null) {
            this.contractScopes = new ArrayList<String>();
        }
        this.contractScopes.addAll(Arrays.asList(scopes));
        return this;
    }

    public SaClientModel addAllowRedirectUris(String ... redirectUris) {
        if (this.allowRedirectUris == null) {
            this.allowRedirectUris = new ArrayList<String>();
        }
        this.allowRedirectUris.addAll(Arrays.asList(redirectUris));
        return this;
    }

    public SaClientModel addAllowGrantTypes(String ... grantTypes) {
        if (this.allowGrantTypes == null) {
            this.allowGrantTypes = new ArrayList<String>();
        }
        this.allowGrantTypes.addAll(Arrays.asList(grantTypes));
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public SaClientModel setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public SaClientModel setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public List<String> getContractScopes() {
        return this.contractScopes;
    }

    public SaClientModel setContractScopes(List<String> contractScopes) {
        this.contractScopes = contractScopes;
        return this;
    }

    public List<String> getAllowRedirectUris() {
        return this.allowRedirectUris;
    }

    public SaClientModel setAllowRedirectUris(List<String> allowRedirectUris) {
        this.allowRedirectUris = allowRedirectUris;
        return this;
    }

    public List<String> getAllowGrantTypes() {
        return this.allowGrantTypes;
    }

    public SaClientModel setAllowGrantTypes(List<String> allowGrantTypes) {
        this.allowGrantTypes = allowGrantTypes;
        return this;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public SaClientModel setSubjectId(String subjectId) {
        this.subjectId = subjectId;
        return this;
    }

    public Boolean getIsNewRefresh() {
        return this.isNewRefresh;
    }

    public SaClientModel setIsNewRefresh(Boolean isNewRefresh) {
        this.isNewRefresh = isNewRefresh;
        return this;
    }

    public long getAccessTokenTimeout() {
        return this.accessTokenTimeout;
    }

    public SaClientModel setAccessTokenTimeout(long accessTokenTimeout) {
        this.accessTokenTimeout = accessTokenTimeout;
        return this;
    }

    public long getRefreshTokenTimeout() {
        return this.refreshTokenTimeout;
    }

    public SaClientModel setRefreshTokenTimeout(long refreshTokenTimeout) {
        this.refreshTokenTimeout = refreshTokenTimeout;
        return this;
    }

    public long getClientTokenTimeout() {
        return this.clientTokenTimeout;
    }

    public SaClientModel setClientTokenTimeout(long clientTokenTimeout) {
        this.clientTokenTimeout = clientTokenTimeout;
        return this;
    }

    public Boolean getIsAutoConfirm() {
        return this.isAutoConfirm;
    }

    public SaClientModel setIsAutoConfirm(Boolean isAutoConfirm) {
        this.isAutoConfirm = isAutoConfirm;
        return this;
    }

    public int getMaxAccessTokenCount() {
        return this.maxAccessTokenCount;
    }

    public SaClientModel setMaxAccessTokenCount(int maxAccessTokenCount) {
        this.maxAccessTokenCount = maxAccessTokenCount;
        return this;
    }

    public int getMaxRefreshTokenCount() {
        return this.maxRefreshTokenCount;
    }

    public SaClientModel setMaxRefreshTokenCount(int maxRefreshTokenCount) {
        this.maxRefreshTokenCount = maxRefreshTokenCount;
        return this;
    }

    public int getMaxClientTokenCount() {
        return this.maxClientTokenCount;
    }

    public SaClientModel setMaxClientTokenCount(int maxClientTokenCount) {
        this.maxClientTokenCount = maxClientTokenCount;
        return this;
    }

    public String toString() {
        return "SaClientModel{clientId='" + this.clientId + '\'' + ", clientSecret='" + this.clientSecret + '\'' + ", contractScopes=" + this.contractScopes + ", allowRedirectUris=" + this.allowRedirectUris + ", allowGrantTypes=" + this.allowGrantTypes + ", subjectId=" + this.subjectId + ", isNewRefresh=" + this.isNewRefresh + ", accessTokenTimeout=" + this.accessTokenTimeout + ", refreshTokenTimeout=" + this.refreshTokenTimeout + ", clientTokenTimeout=" + this.clientTokenTimeout + ", isAutoConfirm=" + this.isAutoConfirm + ", maxAccessTokenCount=" + this.maxAccessTokenCount + ", refreshTokenTimeout=" + this.refreshTokenTimeout + ", maxClientTokenCount=" + this.maxClientTokenCount + '}';
    }
}

