/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.processor;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.config.SaOAuth2ServerConfig;
import cn.dev33.satoken.oauth2.consts.GrantType;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.generate.SaOAuth2DataGenerate;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.data.model.request.ClientIdAndSecretModel;
import cn.dev33.satoken.oauth2.data.model.request.RequestAuthModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.strategy.SaOAuth2Strategy;
import cn.dev33.satoken.oauth2.template.SaOAuth2Template;
import cn.dev33.satoken.router.SaHttpMethod;
import cn.dev33.satoken.util.SaResult;
import java.util.List;

public class SaOAuth2ServerProcessor {
    public static SaOAuth2ServerProcessor instance = new SaOAuth2ServerProcessor();

    public Object dister() {
        SaRequest req = SaHolder.getRequest();
        if (req.isPath(SaOAuth2Consts.Api.authorize)) {
            return this.authorize();
        }
        if (req.isPath(SaOAuth2Consts.Api.token)) {
            return this.token();
        }
        if (req.isPath(SaOAuth2Consts.Api.refresh)) {
            return this.refresh();
        }
        if (req.isPath(SaOAuth2Consts.Api.revoke)) {
            return this.revoke();
        }
        if (req.isPath(SaOAuth2Consts.Api.doLogin)) {
            return this.doLogin();
        }
        if (req.isPath(SaOAuth2Consts.Api.doConfirm)) {
            return this.doConfirm();
        }
        if (req.isPath(SaOAuth2Consts.Api.client_token)) {
            return this.clientToken();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object authorize() {
        SaClientModel cm;
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaOAuth2ServerConfig cfg = SaOAuth2Manager.getServerConfig();
        SaOAuth2DataGenerate dataGenerate = SaOAuth2Manager.getDataGenerate();
        SaOAuth2Template oauth2Template = SaOAuth2Manager.getTemplate();
        String responseType = req.getParamNotNull(SaOAuth2Consts.Param.response_type);
        this.checkAuthorizeResponseType(responseType, req, cfg);
        Object loginId = SaOAuth2Manager.getStpLogic().getLoginIdDefaultNull();
        if (loginId == null) {
            return SaOAuth2Strategy.instance.notLoginView.get();
        }
        RequestAuthModel ra = SaOAuth2Manager.getDataResolver().readRequestAuthModel(req, loginId);
        SaOAuth2Strategy.instance.userAuthorizeClientCheck.run(ra.loginId, (Object)ra.clientId);
        oauth2Template.checkRedirectUri(ra.clientId, ra.redirectUri);
        oauth2Template.checkContractScope(ra.clientId, ra.scopes);
        boolean isNeedCarefulConfirm = oauth2Template.isNeedCarefulConfirm(ra.loginId, ra.clientId, ra.scopes);
        if (isNeedCarefulConfirm && !(cm = oauth2Template.checkClientModel(ra.clientId)).getIsAutoConfirm().booleanValue()) {
            return SaOAuth2Strategy.instance.confirmView.apply(ra.clientId, ra.scopes);
        }
        if (SaOAuth2Consts.ResponseType.code.equals(ra.responseType)) {
            CodeModel codeModel = dataGenerate.generateCode(ra);
            String redirectUri = dataGenerate.buildRedirectUri(ra.redirectUri, codeModel.code, ra.state);
            return res.redirect(redirectUri);
        }
        if (SaOAuth2Consts.ResponseType.token.equals(ra.responseType)) {
            AccessTokenModel at = dataGenerate.generateAccessToken(ra, false, null);
            String redirectUri = dataGenerate.buildImplicitRedirectUri(ra.redirectUri, at.accessToken, ra.state);
            return res.redirect(redirectUri);
        }
        throw new SaOAuth2Exception("\u65e0\u6548 response_type: " + ra.responseType).setCode(30125);
    }

    public Object token() {
        AccessTokenModel accessTokenModel = (AccessTokenModel)SaOAuth2Strategy.instance.grantTypeAuth.apply(SaHolder.getRequest());
        return SaOAuth2Manager.getDataResolver().buildAccessTokenReturnValue(accessTokenModel);
    }

    public Object refresh() {
        SaRequest req = SaHolder.getRequest();
        String grantType = req.getParamNotNull(SaOAuth2Consts.Param.grant_type);
        SaOAuth2Exception.throwBy(!grantType.equals(GrantType.refresh_token), "\u65e0\u6548 grant_type\uff1a" + grantType, 30126);
        AccessTokenModel accessTokenModel = (AccessTokenModel)SaOAuth2Strategy.instance.grantTypeAuth.apply(req);
        return SaOAuth2Manager.getDataResolver().buildRefreshTokenReturnValue(accessTokenModel);
    }

    public Object revoke() {
        SaOAuth2Template oauth2Template = SaOAuth2Manager.getTemplate();
        SaRequest req = SaHolder.getRequest();
        ClientIdAndSecretModel clientIdAndSecret = SaOAuth2Manager.getDataResolver().readClientIdAndSecret(req);
        String clientId = clientIdAndSecret.clientId;
        String clientSecret = clientIdAndSecret.clientSecret;
        String accessToken = req.getParamNotNull(SaOAuth2Consts.Param.access_token);
        if (oauth2Template.getAccessToken(accessToken) == null) {
            return SaResult.ok((String)("access_token \u4e0d\u5b58\u5728\uff1a" + accessToken));
        }
        oauth2Template.checkAccessTokenParam(clientId, clientSecret, accessToken);
        oauth2Template.revokeAccessToken(accessToken);
        return SaOAuth2Manager.getDataResolver().buildRevokeTokenReturnValue();
    }

    public Object doLogin() {
        SaRequest req = SaHolder.getRequest();
        return SaOAuth2Strategy.instance.doLoginHandle.apply(req.getParam(SaOAuth2Consts.Param.name), req.getParam(SaOAuth2Consts.Param.pwd));
    }

    public Object doConfirm() {
        SaRequest req = SaHolder.getRequest();
        String clientId = req.getParamNotNull(SaOAuth2Consts.Param.client_id);
        Object loginId = SaOAuth2Manager.getStpLogic().getLoginId();
        String scope = req.getParamNotNull(SaOAuth2Consts.Param.scope);
        List<String> scopes = SaOAuth2Manager.getDataConverter().convertScopeStringToList(scope);
        SaOAuth2DataGenerate dataGenerate = SaOAuth2Manager.getDataGenerate();
        SaOAuth2Template oauth2Template = SaOAuth2Manager.getTemplate();
        if (!req.isMethod(SaHttpMethod.POST)) {
            throw new SaOAuth2Exception("\u65e0\u6548\u8bf7\u6c42\u65b9\u5f0f\uff1a" + req.getMethod()).setCode(30151);
        }
        oauth2Template.saveGrantScope(clientId, loginId, scopes);
        boolean buildRedirectUri = req.isParam(SaOAuth2Consts.Param.build_redirect_uri, "true");
        if (!buildRedirectUri) {
            oauth2Template.saveGrantScope(clientId, loginId, scopes);
            return SaResult.ok();
        }
        RequestAuthModel ra = SaOAuth2Manager.getDataResolver().readRequestAuthModel(req, loginId);
        if (SaOAuth2Consts.ResponseType.code.equals(ra.responseType)) {
            CodeModel codeModel = dataGenerate.generateCode(ra);
            String redirectUri = dataGenerate.buildRedirectUri(ra.redirectUri, codeModel.code, ra.state);
            return SaResult.ok().set(SaOAuth2Consts.Param.redirect_uri, (Object)redirectUri);
        }
        if (SaOAuth2Consts.ResponseType.token.equals(ra.responseType)) {
            AccessTokenModel at = dataGenerate.generateAccessToken(ra, false, null);
            String redirectUri = dataGenerate.buildImplicitRedirectUri(ra.redirectUri, at.accessToken, ra.state);
            return SaResult.ok().set(SaOAuth2Consts.Param.redirect_uri, (Object)redirectUri);
        }
        throw new SaOAuth2Exception("\u65e0\u6548response_type: " + ra.responseType).setCode(30125);
    }

    public Object clientToken() {
        SaRequest req = SaHolder.getRequest();
        SaOAuth2ServerConfig cfg = SaOAuth2Manager.getServerConfig();
        SaOAuth2Template oauth2Template = SaOAuth2Manager.getTemplate();
        String grantType = req.getParamNotNull(SaOAuth2Consts.Param.grant_type);
        if (!grantType.equals(GrantType.client_credentials)) {
            throw new SaOAuth2Exception("\u65e0\u6548 grant_type\uff1a" + grantType).setCode(30126);
        }
        if (!cfg.enableClientCredentials.booleanValue()) {
            this.throwErrorSystemNotEnableModel();
        }
        if (!this.currClientModel().getAllowGrantTypes().contains(GrantType.client_credentials)) {
            this.throwErrorClientNotEnableModel();
        }
        ClientIdAndSecretModel clientIdAndSecret = SaOAuth2Manager.getDataResolver().readClientIdAndSecret(req);
        String clientId = clientIdAndSecret.clientId;
        String clientSecret = clientIdAndSecret.clientSecret;
        List<String> scopes = SaOAuth2Manager.getDataConverter().convertScopeStringToList(req.getParam(SaOAuth2Consts.Param.scope));
        oauth2Template.checkContractScope(clientId, scopes);
        oauth2Template.checkClientSecret(clientId, clientSecret);
        ClientTokenModel ct = SaOAuth2Manager.getDataGenerate().generateClientToken(clientId, scopes);
        return SaOAuth2Manager.getDataResolver().buildClientTokenReturnValue(ct);
    }

    public SaClientModel currClientModel() {
        SaOAuth2Template oauth2Template = SaOAuth2Manager.getTemplate();
        ClientIdAndSecretModel clientIdAndSecret = SaOAuth2Manager.getDataResolver().readClientIdAndSecret(SaHolder.getRequest());
        return oauth2Template.checkClientModel(clientIdAndSecret.clientId);
    }

    public SaClientModel checkCurrClientSecret() {
        SaOAuth2Template oauth2Template = SaOAuth2Manager.getTemplate();
        ClientIdAndSecretModel clientIdAndSecret = SaOAuth2Manager.getDataResolver().readClientIdAndSecret(SaHolder.getRequest());
        return oauth2Template.checkClientSecret(clientIdAndSecret.clientId, clientIdAndSecret.clientSecret);
    }

    public void checkAuthorizeResponseType(String responseType, SaRequest req, SaOAuth2ServerConfig cfg) {
        if (responseType.equals(SaOAuth2Consts.ResponseType.code)) {
            if (!cfg.enableAuthorizationCode.booleanValue()) {
                this.throwErrorSystemNotEnableModel();
            }
            if (!this.currClientModel().getAllowGrantTypes().contains(GrantType.authorization_code)) {
                this.throwErrorClientNotEnableModel();
            }
        } else if (responseType.equals(SaOAuth2Consts.ResponseType.token)) {
            if (!cfg.enableImplicit.booleanValue()) {
                this.throwErrorSystemNotEnableModel();
            }
            if (!this.currClientModel().getAllowGrantTypes().contains(GrantType.implicit)) {
                this.throwErrorClientNotEnableModel();
            }
        } else {
            throw new SaOAuth2Exception("\u65e0\u6548 response_type: " + responseType).setCode(30125);
        }
    }

    public void throwErrorSystemNotEnableModel() {
        throw new SaOAuth2Exception("\u7cfb\u7edf\u6682\u672a\u5f00\u653e\u6b64\u6388\u6743\u6a21\u5f0f").setCode(30141);
    }

    public void throwErrorClientNotEnableModel() {
        throw new SaOAuth2Exception("\u5e94\u7528\u6682\u672a\u5f00\u653e\u6b64\u6388\u6743\u6a21\u5f0f").setCode(30142);
    }
}

