/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.processor;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoServerConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.sso.processor.SaSsoProcessorHelper;
import cn.dev33.satoken.sso.template.SaSsoServerTemplate;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;

public class SaSsoServerProcessor {
    public static SaSsoServerProcessor instance = new SaSsoServerProcessor();
    public SaSsoServerTemplate ssoServerTemplate = new SaSsoServerTemplate();

    public Object dister() {
        SaRequest req = SaHolder.getRequest();
        SaSsoServerConfig cfg = this.ssoServerTemplate.getServerConfig();
        ApiName apiName = this.ssoServerTemplate.apiName;
        if (req.isPath(apiName.ssoAuth)) {
            return this.ssoAuth();
        }
        if (req.isPath(apiName.ssoDoLogin)) {
            return this.ssoDoLogin();
        }
        if (req.isPath(apiName.ssoCheckTicket) && cfg.getIsHttp().booleanValue()) {
            return this.ssoCheckTicket();
        }
        if (req.isPath(apiName.ssoSignout)) {
            return this.ssoSignout();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoAuth() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoServerConfig cfg = this.ssoServerTemplate.getServerConfig();
        StpLogic stpLogic = this.ssoServerTemplate.getStpLogic();
        ParamName paramName = this.ssoServerTemplate.paramName;
        if (!stpLogic.isLogin()) {
            return cfg.notLoginView.get();
        }
        String mode = req.getParam(paramName.mode, "");
        String redirect = req.getParam(paramName.redirect);
        if (mode.equals("simple")) {
            if (SaFoxUtil.isEmpty((Object)redirect)) {
                if (SaFoxUtil.isEmpty((Object)cfg.getHomeRoute())) {
                    throw new SaSsoException("\u672a\u6307\u5b9a redirect \u53c2\u6570\uff0c\u4e5f\u672a\u914d\u7f6e homeRoute \u8def\u7531\uff0c\u65e0\u6cd5\u5b8c\u6210\u91cd\u5b9a\u5411\u64cd\u4f5c").setCode(30014);
                }
                return res.redirect(cfg.getHomeRoute());
            }
            this.ssoServerTemplate.checkRedirectUrl(redirect);
            return res.redirect(redirect);
        }
        String client = req.getParam(paramName.client);
        if ("*".equals(client)) {
            throw new SaSsoException("\u65e0\u6548 client \u6807\u8bc6\uff1a" + client).setCode(30013);
        }
        if (SaFoxUtil.isEmpty((Object)redirect)) {
            if (SaFoxUtil.isEmpty((Object)cfg.getHomeRoute())) {
                throw new SaSsoException("\u672a\u6307\u5b9a redirect \u53c2\u6570\uff0c\u4e5f\u672a\u914d\u7f6e homeRoute \u8def\u7531\uff0c\u65e0\u6cd5\u5b8c\u6210\u91cd\u5b9a\u5411\u64cd\u4f5c").setCode(30014);
            }
            return res.redirect(cfg.getHomeRoute());
        }
        String redirectUrl = this.ssoServerTemplate.buildRedirectUrl(stpLogic.getLoginId(), client, redirect);
        if (cfg.getAutoRenewTimeout().booleanValue()) {
            stpLogic.renewTimeout(stpLogic.getConfigOrGlobal().getTimeout());
        }
        return res.redirect(redirectUrl);
    }

    public Object ssoDoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaSsoServerConfig cfg = this.ssoServerTemplate.getServerConfig();
        ParamName paramName = this.ssoServerTemplate.paramName;
        return cfg.doLoginHandle.apply(req.getParam(paramName.name), req.getParam(paramName.pwd));
    }

    public Object ssoCheckTicket() {
        ParamName paramName = this.ssoServerTemplate.paramName;
        SaRequest req = SaHolder.getRequest();
        SaSsoServerConfig ssoServerConfig = this.ssoServerTemplate.getServerConfig();
        String client = req.getParam(paramName.client);
        String ticket = req.getParamNotNull(paramName.ticket);
        String sloCallback = req.getParam(paramName.ssoLogoutCall);
        if ("*".equals(client)) {
            return SaResult.error((String)("\u65e0\u6548 client \u6807\u8bc6\uff1a" + client));
        }
        if (ssoServerConfig.getIsCheckSign().booleanValue()) {
            this.ssoServerTemplate.getSignTemplate(client).checkRequest(req, new String[]{paramName.client, paramName.ticket, paramName.ssoLogoutCall});
        } else {
            SaSsoManager.printNoCheckSignWarningByRuntime();
        }
        Object loginId = this.ssoServerTemplate.checkTicket(ticket, client);
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            return SaResult.error((String)("\u65e0\u6548ticket\uff1a" + ticket));
        }
        this.ssoServerTemplate.registerSloCallbackUrl(loginId, client, sloCallback);
        long remainSessionTimeout = this.ssoServerTemplate.getStpLogic().getSessionTimeoutByLoginId(loginId);
        SaResult result = SaResult.data((Object)loginId).set(paramName.remainSessionTimeout, (Object)remainSessionTimeout);
        result = (SaResult)ssoServerConfig.checkTicketAppendData.apply(loginId, result);
        return result;
    }

    public Object ssoSignout() {
        SaRequest req = SaHolder.getRequest();
        SaSsoServerConfig cfg = this.ssoServerTemplate.getServerConfig();
        ParamName paramName = this.ssoServerTemplate.paramName;
        if (cfg.getIsSlo().booleanValue() && !req.hasParam(paramName.loginId)) {
            return this.ssoSignoutByUserVisit();
        }
        if (cfg.getIsSlo().booleanValue() && req.hasParam(paramName.loginId)) {
            return this.ssoSignoutByClientHttp();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoSignoutByUserVisit() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        Object loginId = this.ssoServerTemplate.getStpLogic().getLoginIdDefaultNull();
        if (SaFoxUtil.isNotEmpty((Object)loginId)) {
            this.ssoServerTemplate.ssoLogout(loginId);
        }
        return this.ssoLogoutBack(req, res);
    }

    public Object ssoSignoutByClientHttp() {
        ParamName paramName = this.ssoServerTemplate.paramName;
        SaRequest req = SaHolder.getRequest();
        String loginId = req.getParam(paramName.loginId);
        String client = req.getParam(paramName.client);
        if (this.ssoServerTemplate.getServerConfig().getIsCheckSign().booleanValue()) {
            this.ssoServerTemplate.getSignTemplate(client).checkRequest(req, new String[]{paramName.client, paramName.loginId});
        } else {
            SaSsoManager.printNoCheckSignWarningByRuntime();
        }
        this.ssoServerTemplate.ssoLogout(loginId);
        return SaResult.ok();
    }

    public Object ssoLogoutBack(SaRequest req, SaResponse res) {
        return SaSsoProcessorHelper.ssoLogoutBack(req, res, this.ssoServerTemplate.paramName);
    }
}

