/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.processor;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.config.SaSsoClientConfig;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.model.SaCheckTicketResult;
import cn.dev33.satoken.sso.model.TicketModel;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.sso.processor.SaSsoProcessorHelper;
import cn.dev33.satoken.sso.processor.SaSsoServerProcessor;
import cn.dev33.satoken.sso.template.SaSsoClientTemplate;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.stp.parameter.SaLogoutParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.util.Map;

public class SaSsoClientProcessor {
    public static SaSsoClientProcessor instance = new SaSsoClientProcessor();
    public SaSsoClientTemplate ssoClientTemplate = new SaSsoClientTemplate();

    public Object dister() {
        ApiName apiName = this.ssoClientTemplate.apiName;
        SaRequest req = SaHolder.getRequest();
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        if (req.isPath(apiName.ssoLogin)) {
            return this.ssoLogin();
        }
        if (req.isPath(apiName.ssoLogout)) {
            return this.ssoLogout();
        }
        if (req.isPath(apiName.ssoPushC)) {
            return this.ssoPushC();
        }
        if (req.isPath(apiName.ssoLogoutCall) && cfg.getRegLogoutCall().booleanValue()) {
            return this.ssoLogoutCall();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoLogin() {
        SaRequest req = SaHolder.getRequest();
        ParamName paramName = this.ssoClientTemplate.paramName;
        String ticket = req.getParam(paramName.ticket);
        if (ticket == null) {
            return this._goServerAuth();
        }
        return this._loginByTicket();
    }

    public Object ssoLogout() {
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        if (cfg.getIsSlo().booleanValue()) {
            return this._ssoLogoutByMode3();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoPushC() {
        SaSsoClientConfig ssoClientConfig = this.ssoClientTemplate.getClientConfig();
        Map paramMap = SaHolder.getRequest().getParamMap();
        if (ssoClientConfig.getIsCheckSign().booleanValue()) {
            this.ssoClientTemplate.getSignTemplate().checkParamMap(paramMap);
        } else {
            SaSsoManager.printNoCheckSignWarningByRuntime();
        }
        SaSsoMessage message = new SaSsoMessage(paramMap);
        return this.ssoClientTemplate.handleMessage(message);
    }

    public Object ssoLogoutCall() {
        SaRequest req = SaHolder.getRequest();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogicOrGlobal();
        ParamName paramName = this.ssoClientTemplate.paramName;
        SaSsoClientConfig ssoConfig = this.ssoClientTemplate.getClientConfig();
        Object loginId = req.getParamNotNull(paramName.loginId);
        loginId = this.ssoClientTemplate.strategy.convertCenterIdToLoginId.run(loginId);
        String deviceId = req.getParam(paramName.deviceId);
        if (ssoConfig.getIsCheckSign().booleanValue()) {
            this.ssoClientTemplate.getSignTemplate().checkRequest(req, new String[0]);
        } else {
            SaSsoManager.printNoCheckSignWarningByRuntime();
        }
        SaLogoutParameter logoutParameter = this.ssoClientTemplate.getStpLogicOrGlobal().createSaLogoutParameter();
        stpLogic.logout(loginId, logoutParameter.setDeviceId(deviceId));
        return SaResult.ok((String)"\u5355\u70b9\u6ce8\u9500\u56de\u8c03\u6210\u529f");
    }

    public Object _goServerAuth() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogicOrGlobal();
        ParamName paramName = this.ssoClientTemplate.paramName;
        String back = req.getParam(paramName.back, "/");
        if (stpLogic.isLogin()) {
            return res.redirect(back);
        }
        String currSsoLoginUrl = cfg.getCurrSsoLogin();
        if (SaFoxUtil.isEmpty((Object)currSsoLoginUrl)) {
            currSsoLoginUrl = SaHolder.getRequest().getUrl();
        }
        String serverAuthUrl = this.ssoClientTemplate.buildServerAuthUrl(currSsoLoginUrl, back);
        return res.redirect(serverAuthUrl);
    }

    public Object _loginByTicket() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogicOrGlobal();
        ParamName paramName = this.ssoClientTemplate.paramName;
        ApiName apiName = this.ssoClientTemplate.apiName;
        String back = req.getParam(paramName.back, "/");
        String ticket = req.getParam(paramName.ticket);
        SaCheckTicketResult ctr = this.checkTicket(ticket, apiName.ssoLogin);
        if (this.ssoClientTemplate.strategy.ticketResultHandle != null) {
            return this.ssoClientTemplate.strategy.ticketResultHandle.run(ctr, back);
        }
        stpLogic.login(ctr.loginId, new SaLoginParameter().setTimeout(ctr.remainTokenTimeout.longValue()).setDeviceId(ctr.deviceId));
        return res.redirect(back);
    }

    public Object _ssoLogoutByMode3() {
        Object loginId;
        Object centerId;
        SaSsoMessage message;
        SaResult result;
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogicOrGlobal();
        boolean singleDeviceIdLogout = req.isParam(this.ssoClientTemplate.paramName.singleDeviceIdLogout, "true");
        if (!stpLogic.isLogin()) {
            return this._ssoLogoutBack(req, res);
        }
        SaLogoutParameter logoutParameter = stpLogic.createSaLogoutParameter();
        if (singleDeviceIdLogout) {
            logoutParameter.setDeviceId(stpLogic.getLoginDeviceId());
        }
        if ((result = this.ssoClientTemplate.pushMessageAsSaResult(message = this.ssoClientTemplate.buildSignoutMessage(centerId = this.ssoClientTemplate.strategy.convertLoginIdToCenterId.run(loginId = stpLogic.getLoginId()), logoutParameter))).getCode() == null || 200 != result.getCode()) {
            throw new SaSsoException(result.getMsg()).setCode(30006);
        }
        if (stpLogic.isLogin()) {
            stpLogic.logout(loginId, logoutParameter);
        }
        return this._ssoLogoutBack(req, res);
    }

    public SaCheckTicketResult checkTicket(String ticket) {
        return this.checkTicket(ticket, null);
    }

    public SaCheckTicketResult checkTicket(String ticket, String currUri) {
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        if (cfg.getIsHttp().booleanValue()) {
            return this._checkTicketByHttp(ticket, currUri);
        }
        return this._checkTicketByRedis(ticket);
    }

    public SaCheckTicketResult _checkTicketByHttp(String ticket, String currUri) {
        SaSsoMessage message;
        SaResult result;
        SaSsoClientConfig cfg = this.ssoClientTemplate.getClientConfig();
        ApiName apiName = this.ssoClientTemplate.apiName;
        ParamName paramName = this.ssoClientTemplate.paramName;
        String ssoLogoutCall = null;
        if (cfg.getRegLogoutCall().booleanValue()) {
            if (SaFoxUtil.isNotEmpty((Object)cfg.getCurrSsoLogoutCall())) {
                ssoLogoutCall = cfg.getCurrSsoLogoutCall();
            } else if (SaFoxUtil.isNotEmpty((Object)currUri)) {
                ssoLogoutCall = SaHolder.getRequest().getUrl().replace(currUri, apiName.ssoLogoutCall);
            }
        }
        if ((result = this.ssoClientTemplate.pushMessageAsSaResult(message = this.ssoClientTemplate.buildCheckTicketMessage(ticket, ssoLogoutCall))).getCode() == null || result.getCode() != 200) {
            throw new SaSsoException(result.getMsg()).setCode(30005);
        }
        SaCheckTicketResult ctr = new SaCheckTicketResult();
        ctr.loginId = result.get((Object)paramName.loginId);
        ctr.tokenValue = (String)result.get(paramName.tokenValue, String.class);
        ctr.deviceId = (String)result.get(paramName.deviceId, String.class);
        ctr.remainTokenTimeout = (Long)result.get(paramName.remainTokenTimeout, Long.class);
        ctr.remainSessionTimeout = (Long)result.get(paramName.remainSessionTimeout, Long.class);
        ctr.result = result;
        ctr.centerId = ctr.loginId;
        ctr.loginId = this.ssoClientTemplate.strategy.convertCenterIdToLoginId.run(ctr.centerId);
        return ctr;
    }

    public SaCheckTicketResult _checkTicketByRedis(String ticket) {
        StpLogic stpLogic = this.ssoClientTemplate.getStpLogicOrGlobal();
        TicketModel ticketModel = SaSsoServerProcessor.instance.ssoServerTemplate.checkTicketParamAndDelete(ticket, this.ssoClientTemplate.getClient());
        SaCheckTicketResult ctr = new SaCheckTicketResult();
        ctr.loginId = ticketModel.getLoginId();
        ctr.tokenValue = ticketModel.getTokenValue();
        ctr.deviceId = stpLogic.getLoginDeviceIdByToken(ticketModel.getTokenValue());
        ctr.remainTokenTimeout = stpLogic.getTokenTimeout(ticketModel.getTokenValue());
        ctr.remainSessionTimeout = stpLogic.getSessionTimeoutByLoginId(ticketModel.getLoginId());
        ctr.result = null;
        ctr.centerId = ctr.loginId;
        ctr.loginId = this.ssoClientTemplate.strategy.convertCenterIdToLoginId.run(ctr.centerId);
        return ctr;
    }

    public Object _ssoLogoutBack(SaRequest req, SaResponse res) {
        return SaSsoProcessorHelper.ssoLogoutBack(req, res, this.ssoClientTemplate.paramName);
    }
}

