/*
 * Decompiled with CFR 0.152.
 */
package cn.dhbin.mapstruct.helper.core;

import cn.dhbin.mapstruct.helper.core.ClassKey;
import cn.dhbin.mapstruct.helper.core.MapperConfig;
import cn.dhbin.mapstruct.helper.core.MapperDefinition;
import cn.dhbin.mapstruct.helper.core.exception.MapperDefinitionNotFoundException;
import java.util.Map;
import java.util.function.BiFunction;

public class BeanConvertMappers {
    private static Map<ClassKey, MapperDefinition> mapperDefinitionMap;
    private static MapperConfig mapperConfig;
    private static BiFunction<Object, Object, Object> convertFunction;

    public static synchronized void config(MapperConfig mapperConfig) {
        mapperDefinitionMap = mapperConfig.getMapperDefinitionScanner().scan();
        BeanConvertMappers.mapperConfig = mapperConfig;
        convertFunction = mapperConfig.getConvertFunction();
    }

    public static <S, T, M> M getMapper(Class<S> sourceClass, Class<T> targetClass) {
        if (mapperDefinitionMap == null) {
            throw new NullPointerException("mapperDefinitionMap == null, may not execute init() method");
        }
        if (mapperConfig.isSupportSubclass()) {
            for (Map.Entry<ClassKey, MapperDefinition> definitionEntry : mapperDefinitionMap.entrySet()) {
                ClassKey classKey = definitionEntry.getKey();
                if (!classKey.getSourceClass().isAssignableFrom(sourceClass) || !classKey.getTargetClass().equals(targetClass)) continue;
                return (M)definitionEntry.getValue().getConvert();
            }
            throw new MapperDefinitionNotFoundException(sourceClass, targetClass);
        }
        ClassKey classKey = new ClassKey(sourceClass, targetClass);
        MapperDefinition mapperDefinition = mapperDefinitionMap.get(classKey);
        if (mapperDefinition == null) {
            throw new MapperDefinitionNotFoundException(sourceClass, targetClass);
        }
        return (M)mapperDefinition.getConvert();
    }

    public static <T> T convert(Object source, Class<T> targetClass) {
        Object mapper = BeanConvertMappers.getMapper(source.getClass(), targetClass);
        return (T)convertFunction.apply(mapper, source);
    }

    public static <T> T convert(Object source, T target) {
        return (T)BeanConvertMappers.convert(source, target.getClass());
    }
}

