/*
 * Decompiled with CFR 0.152.
 */
package cn.dhbin.mapstruct.helper.core.scaner;

import cn.dhbin.mapstruct.helper.core.ClassKey;
import cn.dhbin.mapstruct.helper.core.MapperDefinition;
import cn.dhbin.mapstruct.helper.core.scaner.MapperDefinitionScanner;
import cn.hutool.core.util.ClassUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;

public abstract class AbstractPackageMapperDefinitionScanner<M>
implements MapperDefinitionScanner<M> {
    private final String[] scanPackages;

    public AbstractPackageMapperDefinitionScanner(String ... scanPackages) {
        this.scanPackages = scanPackages;
    }

    @Override
    public Map<ClassKey, MapperDefinition> scan() {
        Class mapperClass = this.getMapperClass();
        Reflections reflections = new Reflections(new Object[]{this.scanPackages});
        Set subTypesOf = reflections.getSubTypesOf(mapperClass);
        HashMap<ClassKey, MapperDefinition> mapperDefinitionMap = new HashMap<ClassKey, MapperDefinition>(subTypesOf.size());
        for (Class mapper : subTypesOf) {
            if (mapper.isInterface()) continue;
            try {
                Object instance = mapper.newInstance();
                Class sourceType = ClassUtil.getTypeArgument((Class)mapper, (int)0);
                Class targetType = ClassUtil.getTypeArgument((Class)mapper, (int)1);
                ClassKey classKey = new ClassKey(sourceType, targetType);
                MapperDefinition mapperDefinition = new MapperDefinition(sourceType, targetType, instance);
                mapperDefinitionMap.put(classKey, mapperDefinition);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("can not new instance for " + mapper.getName() + ": " + e.getMessage());
            }
        }
        return mapperDefinitionMap;
    }
}

