package cn.easyproject.easyocr.plugin.linkbold;

import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import cn.easyproject.easyocr.ImageClean;

/**
 * 定义图片清理处理类，完成粘连的粗体字图片清理
 * 
 * @author easyproject.cn
 * 
 */
public class LinkBoldClean extends ImageClean {

	/**
	 * 二值化，取图片的平均灰度作为阈值，二值化的域值，默认值为100，低于该值的全都为0，高于该值的全都为255。
	 * 将整个图像呈现出明显的只有黑和白的视觉效果。
	 * 
	 * @param image 图片对象
	 * @param imageClean 清理类型
	 */
	protected void changeToBinarizationForLinkBold(BufferedImage image,
			ImageClean imageClean) {
		// 设定二值化的域值，默认值为100
		int grey = 117;
		try {
			Method m = imageClean.getClass().getDeclaredMethod("changeToBinarization",
					int.class);
			m.setAccessible(true);
			m.invoke(imageClean, grey);
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
	}
}
