package cn.easyproject.easyocr.plugin.linkbold;

import cn.easyproject.easyocr.Type;

public enum LinkBoldImageType implements Type{

	/**
	 * 定义图片类型枚举项，指定要调用的清理方法 
	 * 格式：清理方法#清理方法2#清理方法3
	 * 1. 清理方法必须加上对应类的完全限定名，格式：类完全限定名.方法
	 * 2. 多个清理方法之间使用#分隔，清理方法会按定义顺序执行
	 * 3. 如果清理方法在cn.easyproject.easyocr.ImageClean中，可以省略类完全限定名部分
	 */
	LINK_BOLD(
			"cn.easyproject.easyocr.plugin.linkbold.LinkBoldClean.changeToBinarizationForLinkBold"
			+ "#reverseGray"
			+ "#changeToGrayByAvgColor"
			+ "#getBlur"
			+ "#changeToBlackWhiteImage"
//			+ "#cleanCrossOrphan"
			);
	
	private final String cleanMethods;

	private LinkBoldImageType(String cleanMethods) {
		this.cleanMethods = cleanMethods;
	}
	/**
	 * 返回方法调用结果
	 * @return 清理方法列表
	 */
	public String getCleanMethods() {
		return this.cleanMethods;
	}
}
