/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.shirorediscache;

import cn.easyproject.shirorediscache.RedisManager;
import cn.easyproject.shirorediscache.SerializeUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisSessionDAO
extends AbstractSessionDAO {
    private static Logger logger = LoggerFactory.getLogger(RedisSessionDAO.class);
    private RedisManager redisManager;
    private RedisTemplate<String, Object> redisTemplate;
    private int expire = 0;
    private String keyPrefix = "shiro_redis_session:";

    public void update(Session session) throws UnknownSessionException {
        this.saveSession(session);
    }

    private void saveSession(Session session) throws UnknownSessionException {
        if (session == null || session.getId() == null) {
            logger.error("session or session id is null");
            return;
        }
        byte[] key = this.getByteKey(session.getId());
        byte[] value = SerializeUtils.serialize(session);
        session.setTimeout((long)(this.getExpire() * 1000));
        if (this.redisTemplate != null) {
            this.redisTemplate.opsForValue().set((Object)this.getKey(session.getId()), (Object)value, (long)this.getExpire(), TimeUnit.SECONDS);
        } else {
            this.redisManager.set(key, value, this.getExpire());
        }
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public void delete(Session session) {
        if (session == null || session.getId() == null) {
            logger.error("session or session id is null");
            return;
        }
        if (this.redisTemplate != null) {
            this.redisTemplate.delete((Object)this.getKey(session.getId()));
        } else {
            this.redisManager.del(this.getByteKey(session.getId()));
        }
    }

    public Collection<Session> getActiveSessions() {
        HashSet<Session> sessions;
        block4: {
            block3: {
                sessions = new HashSet<Session>();
                if (this.redisTemplate == null) break block3;
                Set keys = this.redisTemplate.keys((Object)(this.keyPrefix + "*"));
                if (keys == null || keys.size() <= 0) break block4;
                for (String key : keys) {
                    Session s = (Session)SerializeUtils.deserialize((byte[])this.redisTemplate.opsForValue().get((Object)key));
                    sessions.add(s);
                }
                break block4;
            }
            Set<byte[]> keys = this.redisManager.keys(this.keyPrefix + "*");
            if (keys != null && keys.size() > 0) {
                for (byte[] key : keys) {
                    Session s = (Session)SerializeUtils.deserialize(this.redisManager.get(key));
                    sessions.add(s);
                }
            }
        }
        return sessions;
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        if (sessionId == null) {
            logger.error("session id is null");
            return null;
        }
        Session s = null;
        s = this.redisTemplate != null ? (Session)SerializeUtils.deserialize((byte[])this.redisTemplate.opsForValue().get((Object)this.getKey(sessionId))) : (Session)SerializeUtils.deserialize(this.redisManager.get(this.getByteKey(sessionId)));
        return s;
    }

    private byte[] getByteKey(Serializable sessionId) {
        String preKey = this.keyPrefix + sessionId;
        return preKey.getBytes();
    }

    private String getKey(Serializable sessionId) {
        String preKey = this.keyPrefix + sessionId;
        return preKey;
    }

    public RedisManager getRedisManager() {
        return this.redisManager;
    }

    public void setRedisManager(RedisManager redisManager) {
        this.redisManager = redisManager;
        this.redisManager.init();
        this.redisManager.setExpire(this.getExpire());
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }
}

