/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.shirorediscache;

import cn.easyproject.shirorediscache.SerializeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTemplateCache<K, V>
implements Cache<K, V> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, Object> cache;
    private String keyPrefix = "shiro_redis_session:";

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public RedisTemplateCache(RedisTemplate<String, Object> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.cache = cache;
    }

    public RedisTemplateCache(RedisTemplate<String, Object> cache, String prefix) {
        this(cache);
        this.keyPrefix = prefix;
    }

    private String getKey(K key) {
        String preKey = this.keyPrefix + key;
        return preKey;
    }

    public V get(K key) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4eceRedis\u4e2d\u83b7\u53d6\u5bf9\u8c61 key [" + key + "]");
        try {
            if (key == null) {
                return null;
            }
            byte[] rawValue = (byte[])this.cache.opsForValue().get((Object)this.getKey(key));
            Object value = SerializeUtils.deserialize(rawValue);
            return (V)value;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V put(K key, V value) throws CacheException {
        this.logger.debug("\u6839\u636ekey\u4ece\u5b58\u50a8 key [" + key + "]");
        try {
            System.out.println("==========================================2");
            System.out.println(key);
            System.out.println(new String(this.getKey(key)));
            System.out.println("==========================================2");
            this.cache.opsForValue().set((Object)this.getKey(key), (Object)SerializeUtils.serialize(value));
            return value;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public V remove(K key) throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664 key [" + key + "]");
        try {
            V previous = this.get(key);
            System.out.println("==========================================3");
            System.out.println(key);
            System.out.println(new String(this.getKey(key)));
            System.out.println("==========================================3");
            this.cache.delete((Object)this.getKey(key));
            return previous;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void clear() throws CacheException {
        this.logger.debug("\u4eceredis\u4e2d\u5220\u9664\u6240\u6709\u5143\u7d20");
        try {
            this.cache.execute((RedisCallback)new RedisCallback<String>(){

                public String doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.flushDb();
                    return "ok";
                }
            });
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public int size() {
        try {
            Long longSize = (Long)this.cache.execute((RedisCallback)new RedisCallback<Long>(){

                public Long doInRedis(RedisConnection connection) throws DataAccessException {
                    return connection.dbSize();
                }
            });
            return longSize.intValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Set<K> keys() {
        try {
            Set keys = this.cache.keys((Object)(this.keyPrefix + "*"));
            if (CollectionUtils.isEmpty((Collection)keys)) {
                return Collections.emptySet();
            }
            HashSet<String> newKeys = new HashSet<String>();
            for (String key : keys) {
                newKeys.add(key);
            }
            return newKeys;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Collection<V> values() {
        try {
            Set keys = this.cache.keys((Object)(this.keyPrefix + "*"));
            if (!CollectionUtils.isEmpty((Collection)keys)) {
                ArrayList<V> values = new ArrayList<V>(keys.size());
                for (String key : keys) {
                    V value = this.get(key);
                    if (value == null) continue;
                    values.add(value);
                }
                return Collections.unmodifiableList(values);
            }
            return Collections.emptyList();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }
}

