/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.AgentDetails;
import cn.felord.api.InternalAgentManagerApi;
import cn.felord.domain.WeComResponse;
import cn.felord.domain.agent.AgentDetailsResponse;
import cn.felord.domain.agent.AgentSettingRequest;
import retrofit2.Retrofit;

public class AgentManagerApi {
    private final InternalAgentManagerApi internalAgentManagerApi;
    private final AgentDetails agentDetails;

    AgentManagerApi(Retrofit retrofit, AgentDetails agentDetails) {
        this.internalAgentManagerApi = (InternalAgentManagerApi)retrofit.create(InternalAgentManagerApi.class);
        this.agentDetails = agentDetails;
    }

    public AgentDetailsResponse getAgentDetails() {
        return this.internalAgentManagerApi.getAgentDetails(this.agentDetails.getAgentId());
    }

    public WeComResponse settings(AgentSettingRequest request) {
        return this.internalAgentManagerApi.settings(Settings.from(this.agentDetails.getAgentId(), request));
    }

    public static class Settings
    extends AgentSettingRequest {
        private final String agentid;

        static Settings from(String agentid, AgentSettingRequest request) {
            Settings settings = new Settings(agentid);
            settings.setDescription(request.getDescription());
            settings.setHomeUrl(request.getHomeUrl());
            settings.setIsreportenter(request.getIsreportenter());
            settings.setLogoMediaid(request.getLogoMediaid());
            settings.setName(request.getName());
            settings.setRedirectDomain(request.getRedirectDomain());
            settings.setReportLocationFlag(request.getReportLocationFlag());
            return settings;
        }

        private Settings(String agentid) {
            this.agentid = agentid;
        }

        public String getAgentid() {
            return this.agentid;
        }
    }
}

