/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.AgentDetails;
import cn.felord.api.InternalAgentMessageApi;
import cn.felord.domain.WeComResponse;
import cn.felord.domain.common.MsgId;
import cn.felord.domain.message.AbstractMessageBody;
import cn.felord.domain.message.AbstractUpdateTemplateCardRequest;
import cn.felord.domain.message.MessageResponse;
import java.util.Objects;
import retrofit2.Retrofit;
import retrofit2.http.Body;

public class AgentMessageApi {
    private final InternalAgentMessageApi internalAgentMessageApi;
    private final AgentDetails agentDetails;

    AgentMessageApi(Retrofit retrofit, AgentDetails agentDetails) {
        this.internalAgentMessageApi = (InternalAgentMessageApi)retrofit.create(InternalAgentMessageApi.class);
        this.agentDetails = agentDetails;
    }

    public <B extends AbstractMessageBody> MessageResponse send(B body) {
        String msgtype = body.getMsgtype();
        if (!Objects.equals("miniprogram_notice", msgtype)) {
            String agentId = this.agentDetails.getAgentId();
            body.setAgentid(agentId);
        }
        return this.internalAgentMessageApi.send(body);
    }

    public <R extends AbstractUpdateTemplateCardRequest> MessageResponse updateTemplateCard(R request) {
        return this.internalAgentMessageApi.updateTemplateCard(request);
    }

    public WeComResponse recall(@Body MsgId request) {
        return this.internalAgentMessageApi.recall(request);
    }
}

