/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.api.InternalFileManagerApi;
import cn.felord.domain.wedrive.BufferSource;
import cn.felord.domain.wedrive.FileDownloadResponse;
import cn.felord.domain.wedrive.FileId;
import cn.felord.domain.wedrive.SelectedTicket;
import cn.felord.retrofit.RetrofitFactory;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Url;

public class FileManagerApi {
    private final InternalFileManagerApi internalFileManagerApi;
    private final DownloadApi downloadApi;

    FileManagerApi(Retrofit retrofit) {
        this.internalFileManagerApi = (InternalFileManagerApi)retrofit.create(InternalFileManagerApi.class);
        this.downloadApi = (DownloadApi)RetrofitFactory.RETROFIT_.create(DownloadApi.class);
    }

    public BufferSource downloadByFileId(String fileid) {
        FileDownloadResponse downloadResponse = this.internalFileManagerApi.getFileUrlByFileId(new FileId(fileid));
        return this.download(downloadResponse);
    }

    public BufferSource downloadBySelectedTicket(String selectedTicket) {
        FileDownloadResponse downloadResponse = this.internalFileManagerApi.getFileUrlBySelectedTicket(new SelectedTicket(selectedTicket));
        return this.download(downloadResponse);
    }

    private BufferSource download(FileDownloadResponse downloadResponse) {
        String downloadUrl = downloadResponse.getDownloadUrl();
        String cookie = downloadResponse.getCookieName().concat("=").concat(downloadResponse.getCookieValue());
        try (ResponseBody body = this.downloadApi.download(downloadUrl, cookie);){
            BufferSource bufferSource = new BufferSource(body.contentType(), body.contentLength(), body.source());
            return bufferSource;
        }
    }

    static interface DownloadApi {
        @POST
        public ResponseBody download(@Url String var1, @Header(value="Cookie") String var2);
    }
}

