/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.api.MmPayMktTransfersApi;
import cn.felord.domain.corpay.internal.RedPackRecordRequest;
import cn.felord.domain.corpay.internal.RedPackRecordResponse;
import cn.felord.domain.corpay.internal.RedPackRequest;
import cn.felord.domain.corpay.internal.RedPackResponse;
import cn.felord.domain.corpay.internal.TransPocketRecordRequest;
import cn.felord.domain.corpay.internal.TransPocketRecordResponse;
import cn.felord.domain.corpay.internal.TransPocketRequest;
import cn.felord.domain.corpay.internal.TransPocketResponse;
import cn.felord.enumeration.PaySignType;
import cn.felord.retrofit.RetrofitFactory;
import cn.felord.retrofit.SSLManager;
import cn.felord.xml.XStreamXmlReader;
import okhttp3.ConnectionPool;
import okhttp3.logging.HttpLoggingInterceptor;

public class InternalCorPayApi {
    private final String paySecret;
    private final String payAgentSecret;
    private final MmPayMktTransfersApi mmPayMktTransfersApi;

    InternalCorPayApi(String paySecret, String payAgentSecret, SSLManager sslManager, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        this.paySecret = paySecret;
        this.payAgentSecret = payAgentSecret;
        this.mmPayMktTransfersApi = (MmPayMktTransfersApi)RetrofitFactory.create((SSLManager)sslManager, (ConnectionPool)connectionPool, (HttpLoggingInterceptor.Level)level).create(MmPayMktTransfersApi.class);
    }

    public RedPackResponse sendWorkWxRedPack(RedPackRequest request) {
        request.workWxSign(this.payAgentSecret);
        String xmlResponse = this.mmPayMktTransfersApi.sendWorkWxRedPack(request.xmlBody(this.paySecret, PaySignType.MD5));
        return (RedPackResponse)XStreamXmlReader.INSTANCE.read(xmlResponse, RedPackResponse.class);
    }

    public RedPackRecordResponse queryWorkWxRedPack(RedPackRecordRequest request) {
        String xmlResponse = this.mmPayMktTransfersApi.queryWorkWxRedPack(request.xmlBody(this.paySecret, PaySignType.MD5));
        return (RedPackRecordResponse)XStreamXmlReader.INSTANCE.read(xmlResponse, RedPackRecordResponse.class);
    }

    public TransPocketResponse payWwSpTrans2Pocket(TransPocketRequest request) {
        request.workWxSign(this.payAgentSecret);
        String xmlResponse = this.mmPayMktTransfersApi.payWwSpTrans2Pocket(request.xmlBody(this.paySecret, PaySignType.MD5));
        return (TransPocketResponse)XStreamXmlReader.INSTANCE.read(xmlResponse, TransPocketResponse.class);
    }

    public TransPocketRecordResponse queryWwSpTrans2Pocket(TransPocketRecordRequest request) {
        String xmlResponse = this.mmPayMktTransfersApi.queryWwSpTrans2Pocket(request.xmlBody(this.paySecret, PaySignType.MD5));
        return (TransPocketRecordResponse)XStreamXmlReader.INSTANCE.read(xmlResponse, TransPocketRecordResponse.class);
    }
}

