/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.api.InternalMediaApi;
import cn.felord.domain.GenericResponse;
import cn.felord.domain.common.JobId;
import cn.felord.domain.media.MediaJobResponse;
import cn.felord.domain.media.MediaResponse;
import cn.felord.domain.media.MediaUploadRequest;
import cn.felord.domain.media.MultipartResource;
import cn.felord.enumeration.FileMediaType;
import cn.felord.enumeration.MediaAttachmentType;
import cn.felord.enumeration.MediaTypeEnum;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;
import retrofit2.http.Body;

public class MediaApi {
    private final InternalMediaApi internalMediaApi;

    MediaApi(Retrofit retrofit) {
        this.internalMediaApi = (InternalMediaApi)retrofit.create(InternalMediaApi.class);
    }

    public MediaResponse uploadAttachment(MediaTypeEnum mediaType, MediaAttachmentType attachmentType, MultipartResource resource) {
        return this.internalMediaApi.uploadAttachment(mediaType.type(), attachmentType.getType(), this.toMultipartBody(resource));
    }

    public MediaResponse uploadMedia(MediaTypeEnum mediaType, MultipartResource resource) {
        return this.internalMediaApi.uploadMedia(mediaType.type(), this.toMultipartBody(resource));
    }

    public MediaResponse uploadImage(MultipartResource resource) {
        return this.internalMediaApi.uploadImage(this.toMultipartBody(resource));
    }

    public ResponseBody getMedia(String mediaId) {
        return this.internalMediaApi.getMedia(mediaId);
    }

    public ResponseBody getMediaJsSdk(String mediaId) {
        return this.internalMediaApi.getMediaJsSdk(mediaId);
    }

    public GenericResponse<String> uploadByUrl(MediaUploadRequest request) {
        return this.internalMediaApi.uploadByUrl(request);
    }

    public MediaJobResponse getUploadByUrlResult(@Body JobId jobId) {
        return this.internalMediaApi.getUploadByUrlResult(jobId);
    }

    public GenericResponse<String> uploadPayImage(MultipartResource resource) {
        return this.internalMediaApi.uploadPayImage(this.toMultipartBody(resource));
    }

    private MultipartBody toMultipartBody(MultipartResource resource) {
        String fileName = resource.getFileName();
        MediaType mediaType = Objects.nonNull(resource.getMediaType()) ? resource.getMediaType() : FileMediaType.fromFileName((String)fileName).mediaType();
        RequestBody requestBody = RequestBody.create((byte[])resource.getSource(), (MediaType)mediaType);
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", fileName, requestBody).build();
    }
}

