/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.AgentDetails;
import cn.felord.WeComAgentTicketCacheable;
import cn.felord.api.JsApi;
import cn.felord.api.WorkWeChatApiClient;
import cn.felord.domain.authentication.JsTicketResponse;
import cn.felord.domain.jssdk.AgentConfigResponse;
import cn.felord.domain.jssdk.CorpConfigResponse;
import cn.felord.domain.jssdk.JSignatureResponse;
import cn.felord.utils.Algorithms;
import cn.felord.utils.AlternativeJdkIdGenerator;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Objects;

public class SdkTicketApi {
    private static final String SIGNATURE_FORMATTER = "jsapi_ticket={0}&noncestr={1}&timestamp={2}&url={3}";
    private static final AlternativeJdkIdGenerator ID_GENERATOR = new AlternativeJdkIdGenerator();
    private final AgentDetails agentDetails;
    private final JsApi jsApi;
    private final WeComAgentTicketCacheable weComAgentTicketCacheable;

    SdkTicketApi(WorkWeChatApiClient workWeChatApiClient, WeComAgentTicketCacheable weComAgentTicketCacheable) {
        this.agentDetails = workWeChatApiClient.agentDetails();
        this.jsApi = (JsApi)workWeChatApiClient.retrofit().create(JsApi.class);
        this.weComAgentTicketCacheable = weComAgentTicketCacheable;
    }

    public CorpConfigResponse corpTicket(String url) {
        String agentId;
        String corpId = this.agentDetails.getCorpId();
        String corpTicket = this.weComAgentTicketCacheable.getCorpTicket(corpId, agentId = this.agentDetails.getAgentId());
        if (Objects.isNull(corpTicket)) {
            JsTicketResponse jsTicketResponse = this.jsApi.agentJsApiTicket("agent_config");
            corpTicket = jsTicketResponse.getTicket();
            this.weComAgentTicketCacheable.putCorpTicket(corpId, agentId, corpTicket);
        }
        JSignatureResponse jSignatureResponse = this.sha1(corpTicket, url);
        CorpConfigResponse corpConfigResponse = new CorpConfigResponse();
        corpConfigResponse.setAppId(this.agentDetails.getCorpId());
        corpConfigResponse.setNonceStr(jSignatureResponse.getNonceStr());
        corpConfigResponse.setTimestamp(jSignatureResponse.getTimestamp());
        corpConfigResponse.setSignature(jSignatureResponse.getSignature());
        return corpConfigResponse;
    }

    public AgentConfigResponse agentTicket(String url) {
        String agentId;
        String corpId = this.agentDetails.getCorpId();
        String agentTicket = this.weComAgentTicketCacheable.getAgentTicket(corpId, agentId = this.agentDetails.getAgentId());
        if (Objects.isNull(agentTicket)) {
            JsTicketResponse jsTicketResponse = this.jsApi.agentJsApiTicket("agent_config");
            agentTicket = jsTicketResponse.getTicket();
            this.weComAgentTicketCacheable.putAgentTicket(corpId, agentId, agentTicket);
        }
        JSignatureResponse jSignatureResponse = this.sha1(agentTicket, url);
        AgentConfigResponse agentConfigResponse = new AgentConfigResponse();
        agentConfigResponse.setCorpid(corpId);
        agentConfigResponse.setAgentid(agentId);
        agentConfigResponse.setNonceStr(jSignatureResponse.getNonceStr());
        agentConfigResponse.setTimestamp(jSignatureResponse.getTimestamp());
        agentConfigResponse.setSignature(jSignatureResponse.getSignature());
        return agentConfigResponse;
    }

    private JSignatureResponse sha1(String ticket, String url) {
        String nonceStr = ID_GENERATOR.generate32();
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        String format = MessageFormat.format(SIGNATURE_FORMATTER, ticket, nonceStr, timestamp, url);
        JSignatureResponse jSignature = new JSignatureResponse();
        jSignature.setNonceStr(nonceStr);
        jSignature.setTimestamp(timestamp);
        jSignature.setSignature(Algorithms.sha1Hex((String)format));
        return jSignature;
    }
}

