/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.api.InternalWebhookApi;
import cn.felord.domain.WeComResponse;
import cn.felord.domain.media.MediaResponse;
import cn.felord.domain.media.MultipartResource;
import cn.felord.domain.webhook.WebhookBody;
import cn.felord.enumeration.FileMediaType;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Retrofit;

public class WebhookApi {
    private final InternalWebhookApi internalWebhookApi;

    WebhookApi(Retrofit retrofit) {
        this.internalWebhookApi = (InternalWebhookApi)retrofit.create(InternalWebhookApi.class);
    }

    public <B extends WebhookBody> WeComResponse send(String key, B body) {
        return this.internalWebhookApi.send(key, body);
    }

    public MediaResponse uploadMedia(String webhookKey, MultipartResource resource) {
        String fileName = resource.getFileName();
        MediaType mediaType = Objects.nonNull(resource.getMediaType()) ? resource.getMediaType() : FileMediaType.fromFileName((String)fileName).mediaType();
        RequestBody requestBody = RequestBody.create((byte[])resource.getSource(), (MediaType)mediaType);
        MultipartBody media = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("media", fileName, requestBody).build();
        return this.internalWebhookApi.uploadMedia(webhookKey, "file", media);
    }
}

