/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.api;

import cn.felord.AgentDetails;
import cn.felord.WeComAgentTicketCacheable;
import cn.felord.WeComTokenCacheable;
import cn.felord.api.AgentApi;
import cn.felord.api.ApprovalApi;
import cn.felord.api.AuthApi;
import cn.felord.api.CalendarApi;
import cn.felord.api.CallCenterManager;
import cn.felord.api.ContactBookManager;
import cn.felord.api.DomainApi;
import cn.felord.api.ExternalContactManager;
import cn.felord.api.InvoiceApi;
import cn.felord.api.MediaApi;
import cn.felord.api.PayApi;
import cn.felord.api.ScheduleApi;
import cn.felord.api.SdkTicketApi;
import cn.felord.api.UrgentCallApi;
import cn.felord.api.WeDriveApi;
import cn.felord.api.WebhookApi;
import cn.felord.api.WedocApi;
import cn.felord.api.WorkWeChatApiClient;
import cn.felord.retrofit.AccessTokenApi;
import cn.felord.retrofit.RetrofitFactory;
import okhttp3.ConnectionPool;
import okhttp3.logging.HttpLoggingInterceptor;

public final class WorkWeChatApi {
    private final WeComTokenCacheable weComTokenCacheable;
    private final HttpLoggingInterceptor.Level level;
    private final ConnectionPool connectionPool;

    public WorkWeChatApi(WeComTokenCacheable weComTokenCacheable) {
        this(weComTokenCacheable, new ConnectionPool());
    }

    public WorkWeChatApi(WeComTokenCacheable weComTokenCacheable, ConnectionPool connectionPool) {
        this(weComTokenCacheable, connectionPool, HttpLoggingInterceptor.Level.NONE);
    }

    public WorkWeChatApi(WeComTokenCacheable weComTokenCacheable, HttpLoggingInterceptor.Level level) {
        this(weComTokenCacheable, new ConnectionPool(), level);
    }

    public WorkWeChatApi(WeComTokenCacheable weComTokenCacheable, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        this.weComTokenCacheable = weComTokenCacheable;
        this.connectionPool = connectionPool;
        this.level = level;
    }

    public DomainApi domainApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (DomainApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(DomainApi.class);
    }

    public ContactBookManager contactBookManager(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new ContactBookManager(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level));
    }

    public ExternalContactManager externalContactManager(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new ExternalContactManager(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level));
    }

    public CallCenterManager callCenterManager(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new CallCenterManager(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level));
    }

    public PayApi payApi() {
        return new PayApi(this.weComTokenCacheable, this.connectionPool, this.level);
    }

    public AuthApi authApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (AuthApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(AuthApi.class);
    }

    public AgentApi agentApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new AgentApi(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level));
    }

    public SdkTicketApi sdkTicketApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new SdkTicketApi(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level), (WeComAgentTicketCacheable)this.weComTokenCacheable);
    }

    public static WebhookApi webhookApi() {
        return new WebhookApi(RetrofitFactory.RETROFIT_);
    }

    public MediaApi mediaApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new MediaApi(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit());
    }

    public InvoiceApi invoiceApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (InvoiceApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(InvoiceApi.class);
    }

    public CalendarApi calendarApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (CalendarApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(CalendarApi.class);
    }

    public ScheduleApi scheduleApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (ScheduleApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(ScheduleApi.class);
    }

    public WedocApi wedocApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new WedocApi(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level));
    }

    public WeDriveApi weDriveApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return new WeDriveApi(WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level));
    }

    public ApprovalApi approvalApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (ApprovalApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(ApprovalApi.class);
    }

    public UrgentCallApi urgentCallApi(AgentDetails agentDetails) {
        AccessTokenApi tokenApi = new AccessTokenApi(this.weComTokenCacheable, agentDetails);
        return (UrgentCallApi)WorkWeChatApiClient.init(tokenApi, this.connectionPool, this.level).retrofit().create(UrgentCallApi.class);
    }
}

