/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.crypto;

import cn.felord.payment.PayException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class FileMerchantKeyLoader {
    private static final String TENPAY_ALIAS = "Tenpay Certificate";
    private static final KeyStore PKCS12_KEY_STORE;

    private FileMerchantKeyLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JWK rsaJwk(String storePassword, String path, String merchantId) throws PayException {
        char[] pin = storePassword.toCharArray();
        try (FileInputStream fileInputStream = new FileInputStream(path);){
            PKCS12_KEY_STORE.load(fileInputStream, pin);
            RSAKey rsaKey = RSAKey.load((KeyStore)PKCS12_KEY_STORE, (String)TENPAY_ALIAS, (char[])pin);
            RSAKey rSAKey = new RSAKey.Builder(rsaKey).keyID(merchantId).build();
            return rSAKey;
        }
        catch (JOSEException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new PayException("Fail to load tenpay certificate", e);
        }
    }

    static {
        try {
            PKCS12_KEY_STORE = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException var1) {
            throw new PayException("Wechat pay keystore initialization failed");
        }
    }
}

