/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.domain.busifavor;

import cn.felord.payment.wechat.enumeration.BusiFavorUseMethod;
import cn.felord.payment.wechat.enumeration.CouponCodeMode;
import cn.felord.payment.wechat.enumeration.StockType;
import cn.felord.payment.wechat.v3.domain.busifavor.CouponAvailableTime;
import cn.felord.payment.wechat.v3.domain.busifavor.CouponUseRule;
import cn.felord.payment.wechat.v3.domain.busifavor.CustomEntrance;
import cn.felord.payment.wechat.v3.domain.busifavor.DiscountCoupon;
import cn.felord.payment.wechat.v3.domain.busifavor.DisplayPatternInfo;
import cn.felord.payment.wechat.v3.domain.busifavor.ExchangeCoupon;
import cn.felord.payment.wechat.v3.domain.busifavor.FavorNotifyConfig;
import cn.felord.payment.wechat.v3.domain.busifavor.FixedNormalCoupon;
import cn.felord.payment.wechat.v3.domain.busifavor.StockSendRule;
import lombok.Generated;

public class FavorCreateParams {
    private final String stockName;
    private final String belongMerchant;
    private final String goodsName;
    private String comment;
    private final StockType stockType;
    private final CouponUseRule couponUseRule;
    private CustomEntrance customEntrance;
    private final CouponCodeMode couponCodeMode;
    private DisplayPatternInfo displayPatternInfo;
    private final StockSendRule stockSendRule;
    private final String outRequestNo;
    private FavorNotifyConfig notifyConfig;
    private Boolean subsidy;

    public static FavorCreateParams normal(String stockName, String belongMerchant, String goodsName, BusiFavorUseMethod useMethod, CouponAvailableTime availableTime, FixedNormalCoupon fixedNormalCoupon, CouponCodeMode couponCodeMode, StockSendRule stockSendRule, String outRequestNo) {
        return new FavorCreateParams(stockName, belongMerchant, goodsName, StockType.NORMAL, CouponUseRule.fixedNormalCoupon(useMethod, availableTime, fixedNormalCoupon), couponCodeMode, stockSendRule, outRequestNo);
    }

    public static FavorCreateParams discount(String stockName, String belongMerchant, String goodsName, BusiFavorUseMethod useMethod, CouponAvailableTime availableTime, DiscountCoupon discountCoupon, CouponCodeMode couponCodeMode, StockSendRule stockSendRule, String outRequestNo) {
        return new FavorCreateParams(stockName, belongMerchant, goodsName, StockType.DISCOUNT, CouponUseRule.discountCoupon(useMethod, availableTime, discountCoupon), couponCodeMode, stockSendRule, outRequestNo);
    }

    public static FavorCreateParams exchange(String stockName, String belongMerchant, String goodsName, BusiFavorUseMethod useMethod, CouponAvailableTime availableTime, ExchangeCoupon exchangeCoupon, CouponCodeMode couponCodeMode, StockSendRule stockSendRule, String outRequestNo) {
        return new FavorCreateParams(stockName, belongMerchant, goodsName, StockType.EXCHANGE, CouponUseRule.exchangeCoupon(useMethod, availableTime, exchangeCoupon), couponCodeMode, stockSendRule, outRequestNo);
    }

    FavorCreateParams(String stockName, String belongMerchant, String goodsName, StockType stockType, CouponUseRule couponUseRule, CouponCodeMode couponCodeMode, StockSendRule stockSendRule, String outRequestNo) {
        this.stockName = stockName;
        this.belongMerchant = belongMerchant;
        this.goodsName = goodsName;
        this.stockType = stockType;
        this.couponUseRule = couponUseRule;
        this.couponCodeMode = couponCodeMode;
        this.stockSendRule = stockSendRule;
        this.outRequestNo = outRequestNo;
    }

    public FavorCreateParams comment(String comment) {
        this.comment = comment;
        return this;
    }

    public FavorCreateParams customEntrance(CustomEntrance customEntrance) {
        this.customEntrance = customEntrance;
        return this;
    }

    public FavorCreateParams displayPatternInfo(DisplayPatternInfo displayPatternInfo) {
        this.displayPatternInfo = displayPatternInfo;
        return this;
    }

    public FavorCreateParams notifyConfig(FavorNotifyConfig notifyConfig) {
        this.notifyConfig = notifyConfig;
        return this;
    }

    public FavorCreateParams subsidy(Boolean subsidy) {
        this.subsidy = subsidy;
        return this;
    }

    public FavorCreateParams miniProgramsAppid(String miniProgramsAppid) {
        this.couponUseRule.miniProgramsAppid(miniProgramsAppid);
        return this;
    }

    public FavorCreateParams miniProgramsPath(String miniProgramsPath) {
        this.couponUseRule.miniProgramsPath(miniProgramsPath);
        return this;
    }

    @Generated
    public String toString() {
        return "FavorCreateParams(stockName=" + this.getStockName() + ", belongMerchant=" + this.getBelongMerchant() + ", goodsName=" + this.getGoodsName() + ", comment=" + this.getComment() + ", stockType=" + (Object)((Object)this.getStockType()) + ", couponUseRule=" + this.getCouponUseRule() + ", customEntrance=" + this.getCustomEntrance() + ", couponCodeMode=" + (Object)((Object)this.getCouponCodeMode()) + ", displayPatternInfo=" + this.getDisplayPatternInfo() + ", stockSendRule=" + this.getStockSendRule() + ", outRequestNo=" + this.getOutRequestNo() + ", notifyConfig=" + this.getNotifyConfig() + ", subsidy=" + this.getSubsidy() + ")";
    }

    @Generated
    public String getStockName() {
        return this.stockName;
    }

    @Generated
    public String getBelongMerchant() {
        return this.belongMerchant;
    }

    @Generated
    public String getGoodsName() {
        return this.goodsName;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public StockType getStockType() {
        return this.stockType;
    }

    @Generated
    public CouponUseRule getCouponUseRule() {
        return this.couponUseRule;
    }

    @Generated
    public CustomEntrance getCustomEntrance() {
        return this.customEntrance;
    }

    @Generated
    public CouponCodeMode getCouponCodeMode() {
        return this.couponCodeMode;
    }

    @Generated
    public DisplayPatternInfo getDisplayPatternInfo() {
        return this.displayPatternInfo;
    }

    @Generated
    public StockSendRule getStockSendRule() {
        return this.stockSendRule;
    }

    @Generated
    public String getOutRequestNo() {
        return this.outRequestNo;
    }

    @Generated
    public FavorNotifyConfig getNotifyConfig() {
        return this.notifyConfig;
    }

    @Generated
    public Boolean getSubsidy() {
        return this.subsidy;
    }
}

