/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.domain.certificate;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.crypto.CipherAlg;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import lombok.Generated;

public class EncryptCertificate {
    private String associatedData;
    private String ciphertext;
    private String nonce;
    private CipherAlg algorithm;

    public JWK toJwk(String apiV3Secret) throws PayException {
        String tenPayPublicKey = this.getAlgorithm().wecomCipher().decrypt(apiV3Secret, this.associatedData, this.nonce, this.ciphertext);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(tenPayPublicKey.getBytes(StandardCharsets.UTF_8));
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            x509Certificate.checkValidity();
            return JWK.parse((X509Certificate)x509Certificate);
        }
        catch (JOSEException | CertificateException e) {
            throw new PayException("Fail to get tenpay certificate", e);
        }
    }

    @Generated
    public EncryptCertificate() {
    }

    @Generated
    public String getAssociatedData() {
        return this.associatedData;
    }

    @Generated
    public String getCiphertext() {
        return this.ciphertext;
    }

    @Generated
    public String getNonce() {
        return this.nonce;
    }

    @Generated
    public CipherAlg getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public void setAssociatedData(String associatedData) {
        this.associatedData = associatedData;
    }

    @Generated
    public void setCiphertext(String ciphertext) {
        this.ciphertext = ciphertext;
    }

    @Generated
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    @Generated
    public void setAlgorithm(CipherAlg algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptCertificate)) {
            return false;
        }
        EncryptCertificate other = (EncryptCertificate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$associatedData = this.getAssociatedData();
        String other$associatedData = other.getAssociatedData();
        if (this$associatedData == null ? other$associatedData != null : !this$associatedData.equals(other$associatedData)) {
            return false;
        }
        String this$ciphertext = this.getCiphertext();
        String other$ciphertext = other.getCiphertext();
        if (this$ciphertext == null ? other$ciphertext != null : !this$ciphertext.equals(other$ciphertext)) {
            return false;
        }
        String this$nonce = this.getNonce();
        String other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
            return false;
        }
        CipherAlg this$algorithm = this.getAlgorithm();
        CipherAlg other$algorithm = other.getAlgorithm();
        return !(this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EncryptCertificate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $associatedData = this.getAssociatedData();
        result = result * 59 + ($associatedData == null ? 43 : $associatedData.hashCode());
        String $ciphertext = this.getCiphertext();
        result = result * 59 + ($ciphertext == null ? 43 : $ciphertext.hashCode());
        String $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
        CipherAlg $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EncryptCertificate(associatedData=" + this.getAssociatedData() + ", ciphertext=" + this.getCiphertext() + ", nonce=" + this.getNonce() + ", algorithm=" + (Object)((Object)this.getAlgorithm()) + ")";
    }
}

