/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.retrofit;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.WepaySdkVersion;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.crypto.WechatPaySigner;
import cn.felord.payment.wechat.v3.retrofit.WechatHttpHeaders;
import cn.felord.utils.OkHttpUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAuthorizationInterceptor
implements Interceptor {
    private static final String APPLICATION_JSON_UTF_8 = "application/json; charset=UTF-8";
    private static final String DOWNLOAD_FILE_PATH = "/v3/billdownload/file";
    private final AppMerchant appMerchant;

    public AbstractAuthorizationInterceptor(AppMerchant appMerchant) {
        this.appMerchant = appMerchant;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Headers headers = request.headers();
        String mediaBody = headers.get(WechatHttpHeaders.META.headerName());
        String bodyStr = Optional.ofNullable(mediaBody).orElseGet(() -> Optional.ofNullable(request.body()).map(OkHttpUtil::requestBodyToString).orElse(""));
        HttpUrl httpUrl = request.url();
        String authorization = WechatPaySigner.sign(this.appMerchant, httpUrl.uri(), request.method(), bodyStr);
        Headers.Builder headerBuilder = headers.newBuilder();
        String contentType = WechatHttpHeaders.CONTENT_TYPE.headerName();
        if (Objects.isNull(headers.get(contentType))) {
            headerBuilder.set(contentType, APPLICATION_JSON_UTF_8);
        }
        Request requestWithAuth = request.newBuilder().url(httpUrl).header(WechatHttpHeaders.AUTHORIZATION.headerName(), authorization).header(WechatHttpHeaders.USER_AGENT.headerName(), WepaySdkVersion.USER_AGENT).header(WechatHttpHeaders.ACCEPT.headerName(), "*/*").build();
        Response response = chain.proceed(requestWithAuth);
        if (!Objects.equals(DOWNLOAD_FILE_PATH, httpUrl.encodedPath())) {
            this.verifyResponse(response);
        }
        return response;
    }

    protected abstract void verifyResponse(Response var1) throws PayException;
}

