/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.retrofit;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.crypto.TenpayKey;
import cn.felord.payment.wechat.v3.retrofit.AbstractAuthorizationInterceptor;
import cn.felord.payment.wechat.v3.retrofit.InternalCertificateApi;
import cn.felord.payment.wechat.v3.retrofit.ResponseBodyCallAdapterFactory;
import cn.felord.payment.wechat.v3.retrofit.TenpayKeyCache;
import cn.felord.retrofit.json.JsonConverterFactory;
import com.nimbusds.jose.jwk.JWK;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;

class TenpayCertificateService {
    private final AppMerchant appMerchant;
    private final TenpayKeyCache tenpayKeyCache;
    private final InternalCertificateApi certificateApi;

    TenpayCertificateService(String baseUrl, AppMerchant appMerchant, TenpayKeyCache tenpayKeyCache) {
        this.appMerchant = appMerchant;
        this.tenpayKeyCache = tenpayKeyCache;
        this.certificateApi = (InternalCertificateApi)new TenpayCertificateRetrofitFactory(baseUrl).app(appMerchant).create(InternalCertificateApi.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void certificates() throws PayException {
        AppMerchant appMerchant = this.appMerchant;
        synchronized (appMerchant) {
            this.certificateApi.certificates().getData().forEach(tenpayCertificate -> {
                String merchantId = this.appMerchant.merchantId();
                String serialNo = tenpayCertificate.getSerialNo();
                JWK tenPayJwk = tenpayCertificate.getEncryptCertificate().toJwk(this.appMerchant.getApiV3Secret());
                TenpayKey tenpayKey = new TenpayKey(merchantId, serialNo, tenPayJwk);
                this.tenpayKeyCache.putTenpayKey(merchantId, serialNo, tenpayKey);
            });
        }
    }

    public TenpayKey getTenpayKey(String serialNumber) {
        TenpayKey tenpayKey = this.tenpayKeyCache.getTenpayKey(this.appMerchant.merchantId(), serialNumber);
        if (Objects.isNull(tenpayKey)) {
            this.certificates();
            tenpayKey = this.tenpayKeyCache.getTenpayKey(this.appMerchant.merchantId(), serialNumber);
            if (Objects.isNull(tenpayKey)) {
                throw new PayException("Fail to load tenpayKey");
            }
        }
        return tenpayKey;
    }

    static class TenpayCertificateAuthorizationInterceptor
    extends AbstractAuthorizationInterceptor {
        public TenpayCertificateAuthorizationInterceptor(AppMerchant appMerchant) {
            super(appMerchant);
        }

        @Override
        protected void verifyResponse(Response response) throws PayException {
        }
    }

    static class TenpayCertificateRetrofitFactory {
        private static final String DEFAULT_BASE_URL = "https://api.mch.weixin.qq.com/";
        private final String baseUrl;
        private final ConnectionPool connectionPool;
        private final HttpLoggingInterceptor.Level level;

        public TenpayCertificateRetrofitFactory() {
            this(DEFAULT_BASE_URL);
        }

        public TenpayCertificateRetrofitFactory(String baseUrl) {
            this(baseUrl, new ConnectionPool(), HttpLoggingInterceptor.Level.NONE);
        }

        public TenpayCertificateRetrofitFactory(String baseUrl, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
            this.baseUrl = baseUrl;
            this.connectionPool = connectionPool;
            this.level = level;
        }

        public Retrofit app(AppMerchant appMerchant) {
            return new Retrofit.Builder().baseUrl(this.baseUrl).client(TenpayCertificateRetrofitFactory.okHttpClient(appMerchant, this.connectionPool, this.level)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)new ResponseBodyCallAdapterFactory()).addConverterFactory((Converter.Factory)JsonConverterFactory.create()).build();
        }

        private static OkHttpClient okHttpClient(AppMerchant appMerchant, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
            HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
            httpLoggingInterceptor.level(level);
            TenpayCertificateAuthorizationInterceptor authorizationInterceptor = new TenpayCertificateAuthorizationInterceptor(appMerchant);
            return new OkHttpClient.Builder().connectionPool(connectionPool).addInterceptor((Interceptor)authorizationInterceptor).addInterceptor((Interceptor)httpLoggingInterceptor).retryOnConnectionFailure(true).connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
        }
    }
}

