/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.payment.wechat.v3.retrofit;

import cn.felord.payment.PayException;
import cn.felord.payment.wechat.v3.crypto.AppMerchant;
import cn.felord.payment.wechat.v3.crypto.TenpayKey;
import cn.felord.payment.wechat.v3.crypto.WechatPaySigner;
import cn.felord.payment.wechat.v3.retrofit.AbstractAuthorizationInterceptor;
import cn.felord.payment.wechat.v3.retrofit.TenpayCertificateService;
import cn.felord.payment.wechat.v3.retrofit.WechatHttpHeaders;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

class WechatAuthorizationInterceptor
extends AbstractAuthorizationInterceptor {
    private final TenpayCertificateService tenpayCertificateService;

    WechatAuthorizationInterceptor(AppMerchant appMerchant, TenpayCertificateService tenpayCertificateService) {
        super(appMerchant);
        this.tenpayCertificateService = tenpayCertificateService;
    }

    @Override
    protected void verifyResponse(Response response) throws PayException {
        ResponseBody responseBody = response.body();
        String body = "";
        if (Objects.nonNull(responseBody)) {
            BufferedSource source = responseBody.source();
            try {
                source.request(Long.MAX_VALUE);
            }
            catch (IOException e) {
                throw new PayException("Fail Request", e);
            }
            try (Buffer buffer = source.getBuffer().clone();){
                body = buffer.readUtf8();
            }
        }
        Headers responseHeaders = response.headers();
        if (!response.isSuccessful()) {
            String requestId = responseHeaders.get(WechatHttpHeaders.REQUEST_ID.headerName());
            String errorMessage = " Code: " + response.code() + "\n Request-ID: " + requestId + "\n Message: " + response.message() + "\n Body: " + body;
            response.close();
            throw new PayException(errorMessage);
        }
        String serialNumber = responseHeaders.get(WechatHttpHeaders.WECHAT_PAY_SERIAL.headerName());
        TenpayKey tenpayKey = this.tenpayCertificateService.getTenpayKey(serialNumber);
        if (!WechatPaySigner.verify(responseHeaders, body, tenpayKey)) {
            String requestId = responseHeaders.get(WechatHttpHeaders.REQUEST_ID.headerName());
            response.close();
            throw new PayException("Wechat pay signature verify failed, Request-ID: " + requestId);
        }
    }
}

