package cn.gnux.core.utils.db.ds.pool;


import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

/**
 * 连接包装，用于丰富功能
 * @author Looly
 *
 */
public abstract class ConnectionWraper implements Connection{
	
	protected Connection realConn;//真正的连接

	public <T> T unwrap(Class<T> iface) throws SQLException {
		return realConn.unwrap(iface);
	}

	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return realConn.isWrapperFor(iface);
	}

	public Statement createStatement() throws SQLException {
		return realConn.createStatement();
	}

	public PreparedStatement prepareStatement(String sql) throws SQLException {
		return realConn.prepareStatement(sql);
	}

	public CallableStatement prepareCall(String sql) throws SQLException {
		return realConn.prepareCall(sql);
	}

	public String nativeSQL(String sql) throws SQLException {
		return realConn.nativeSQL(sql);
	}

	public void setAutoCommit(boolean autoCommit) throws SQLException {
		realConn.setAutoCommit(autoCommit);
	}

	public boolean getAutoCommit() throws SQLException {
		return realConn.getAutoCommit();
	}

	public void commit() throws SQLException {
		realConn.commit();
	}

	public void rollback() throws SQLException {
		realConn.rollback();
	}

	public DatabaseMetaData getMetaData() throws SQLException {
		return realConn.getMetaData();
	}

	public void setReadOnly(boolean readOnly) throws SQLException {
		realConn.setReadOnly(readOnly);
	}

	public boolean isReadOnly() throws SQLException {
		return realConn.isReadOnly();
	}

	public void setCatalog(String catalog) throws SQLException {
		realConn.setCatalog(catalog);
	}

	public String getCatalog() throws SQLException {
		return realConn.getCatalog();
	}

	public void setTransactionIsolation(int level) throws SQLException {
		realConn.setTransactionIsolation(level);
	}

	public int getTransactionIsolation() throws SQLException {
		return realConn.getTransactionIsolation();
	}

	public SQLWarning getWarnings() throws SQLException {
		return realConn.getWarnings();
	}

	public void clearWarnings() throws SQLException {
		realConn.clearWarnings();
	}

	public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
		return realConn.createStatement(resultSetType, resultSetConcurrency);
	}

	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
		return realConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
	}

	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
		return realConn.prepareCall(sql, resultSetType, resultSetConcurrency);
	}

	public Map<String, Class<?>> getTypeMap() throws SQLException {
		return realConn.getTypeMap();
	}

	public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
		realConn.setTypeMap(map);
	}

	public void setHoldability(int holdability) throws SQLException {
		realConn.setHoldability(holdability);
	}

	public int getHoldability() throws SQLException {
		return realConn.getHoldability();
	}

	public Savepoint setSavepoint() throws SQLException {
		return realConn.setSavepoint();
	}

	public Savepoint setSavepoint(String name) throws SQLException {
		return realConn.setSavepoint(name);
	}

	public void rollback(Savepoint savepoint) throws SQLException {
		realConn.rollback(savepoint);
	}

	public void releaseSavepoint(Savepoint savepoint) throws SQLException {
		realConn.releaseSavepoint(savepoint);
	}

	public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
		return realConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
		return realConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
		return realConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
		return realConn.prepareStatement(sql, autoGeneratedKeys);
	}

	public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
		return realConn.prepareStatement(sql, columnIndexes);
	}

	public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
		return realConn.prepareStatement(sql, columnNames);
	}

	public Clob createClob() throws SQLException {
		return realConn.createClob();
	}

	public Blob createBlob() throws SQLException {
		return realConn.createBlob();
	}

	public NClob createNClob() throws SQLException {
		return realConn.createNClob();
	}

	public SQLXML createSQLXML() throws SQLException {
		return realConn.createSQLXML();
	}

	public boolean isValid(int timeout) throws SQLException {
		return realConn.isValid(timeout);
	}

	public void setClientInfo(String name, String value) throws SQLClientInfoException {
		realConn.setClientInfo(name, value);
	}

	public void setClientInfo(Properties properties) throws SQLClientInfoException {
		realConn.setClientInfo(properties);
	}

	public String getClientInfo(String name) throws SQLException {
		return realConn.getClientInfo(name);
	}

	public Properties getClientInfo() throws SQLException {
		return realConn.getClientInfo();
	}

	public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
		return realConn.createArrayOf(typeName, elements);
	}

	public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
		return realConn.createStruct(typeName, attributes);
	}

	public void setSchema(String schema) throws SQLException {
		realConn.setSchema(schema);
	}

	public String getSchema() throws SQLException {
		return realConn.getSchema();
	}

	public void abort(Executor executor) throws SQLException {
		realConn.abort(executor);
	}

	public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
		realConn.setNetworkTimeout(executor, milliseconds);
	}

	public int getNetworkTimeout() throws SQLException {
		return realConn.getNetworkTimeout();
	}

	/**
	 * @return 实际的连接对象
	 */
	public Connection getRealConnection(){
		return this.realConn;
	}
}
